/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.util;

import io.confluent.connect.sqs.source.SqsSourceConnectorConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;

public class SqsProxyConfig {
    private final String protocol;
    private final String host;
    private final int port;
    private final String user;
    private final String pass;

    public SqsProxyConfig(SqsSourceConnectorConfig config) {
        try {
            URL url = new URL(config.getString("sqs.proxy.url"));
            this.protocol = SqsProxyConfig.extractProtocol(url.getProtocol());
            this.host = url.getHost();
            this.port = url.getPort();
            String username = config.getString("sqs.proxy.user");
            this.user = SqsProxyConfig.isNotBlank(username) ? username : SqsProxyConfig.extractUser(url.getUserInfo());
            Password password = config.getPassword("sqs.proxy.password");
            this.pass = SqsProxyConfig.isNotBlank(password.value()) ? password.value() : SqsProxyConfig.extractPass(url.getUserInfo());
        }
        catch (MalformedURLException e) {
            throw new ConfigException("sqs.proxy.url", (Object)config.getString("sqs.proxy.url"), e.toString());
        }
    }

    public static String extractProtocol(String protocol) {
        if (SqsProxyConfig.isBlank(protocol)) {
            return Protocol.HTTPS.toString();
        }
        return "http".equals(protocol.trim().toLowerCase(Locale.ROOT)) ? Protocol.HTTP.toString() : Protocol.HTTPS.toString();
    }

    public static String extractUser(String userInfo) {
        return SqsProxyConfig.isBlank(userInfo) ? null : userInfo.split(":")[0];
    }

    public static String extractPass(String userInfo) {
        if (SqsProxyConfig.isBlank(userInfo)) {
            return null;
        }
        String[] parts = userInfo.split(":", 2);
        return parts.length == 2 ? parts[1] : null;
    }

    private static boolean isNotBlank(String str) {
        return !SqsProxyConfig.isBlank(str);
    }

    private static boolean isBlank(String str) {
        return str == null || str.isEmpty();
    }

    public ProxyConfiguration getProxyConfiguration() {
        return (ProxyConfiguration)ProxyConfiguration.builder().host(this.host).port(this.port).scheme(this.protocol).password(this.pass).username(this.user).build();
    }
}

