/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.util;

import io.confluent.connect.sqs.source.SqsSourceConnectorConfig;
import io.confluent.connect.sqs.util.SqsProxyConfig;
import org.apache.kafka.common.config.ConfigException;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;

public class SqsClientUtil {
    public static SqsAsyncClient createAsyncClient(SqsSourceConnectorConfig connectorConfig) throws UnableToInferSqsRegionException, InvalidCredentialProviderException {
        SqsAsyncClientBuilder builder = SqsAsyncClient.builder();
        try {
            ((SqsAsyncClientBuilder)builder.region(Region.of((String)connectorConfig.region()))).credentialsProvider(connectorConfig.getCredentialsProvider());
        }
        catch (ConfigException e) {
            throw new UnableToInferSqsRegionException((Exception)((Object)e));
        }
        RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(connectorConfig.getInt("sqs.max.retries")).build();
        ClientOverrideConfiguration.Builder overrideConfigBuilder = builder.overrideConfiguration().toBuilder();
        overrideConfigBuilder.retryPolicy(retryPolicy);
        builder.overrideConfiguration((ClientOverrideConfiguration)overrideConfigBuilder.build());
        String proxyUrl = connectorConfig.getString("sqs.proxy.url");
        NettyNioAsyncHttpClient.Builder nettyHttpClientBuilder = NettyNioAsyncHttpClient.builder();
        if (proxyUrl != null && !proxyUrl.isEmpty()) {
            SqsProxyConfig proxyConfig = new SqsProxyConfig(connectorConfig);
            nettyHttpClientBuilder.proxyConfiguration(proxyConfig.getProxyConfiguration());
        }
        builder.httpClient(nettyHttpClientBuilder.build());
        return (SqsAsyncClient)builder.build();
    }

    public static class InvalidCredentialProviderException
    extends Exception {
        public InvalidCredentialProviderException(Exception e) {
            super(e);
        }
    }

    public static class UnableToInferSqsRegionException
    extends Exception {
        public UnableToInferSqsRegionException(Exception e) {
            super(e);
        }
    }
}

