/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.kafka.common.config.ConfigException;

public class RegionUtil {
    private RegionUtil() {
    }

    public static String extractRegion(String sqsQueueUrl) {
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            try {
                URL url = new URL(sqsQueueUrl);
                String[] tokens = url.getHost().toLowerCase().split("\\.");
                region = tokens[tokens.length - 3];
            }
            catch (MalformedURLException e) {
                throw new ConfigException("Could not determine AWS region based on SQS url [" + sqsQueueUrl + "]", (Object)e);
            }
        }
        return region;
    }
}

