/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.source;

import io.confluent.connect.sqs.util.RegionUtil;
import io.confluent.connect.sqs.util.SqsClientUtil;
import io.confluent.connect.utils.licensing.LicenseConfigUtil;
import io.confluent.connect.utils.validators.Validators;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class SqsSourceConnectorConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(SqsSourceConnectorConfig.class);
    public static final String AWS_ACCESS_KEY_ID_CONFIG = "aws.access.key.id";
    private static final String AWS_ACCESS_KEY_ID_DOC = "The AWS access key that will be used to connect to SQS.";
    private static final String AWS_ACCESS_KEY_ID_DISPLAY = "AWS Access Key Id";
    private static final String AWS_ACCESS_KEY_ID_DEFAULT = null;
    public static final String AWS_SECRET_KEY_ID_CONFIG = "aws.secret.key.id";
    private static final String AWS_SECRET_KEY_ID_DOC = "The AWS secret key that will be used to connect to SQS.";
    private static final String AWS_SECRET_KEY_ID_DISPLAY = "AWS Secret Key Id";
    private static final Password AWS_SECRET_KEY_ID_DEFAULT = null;
    public static final String CREDENTIALS_PROVIDER_CLASS_CONFIG = "sqs.credentials.provider.class";
    public static final String INVALID_CREDENTIAL_PROVIDER_CLASS_MSG = "Unable to invoke static method create()";
    public static final Class<? extends AwsCredentialsProvider> CREDENTIALS_PROVIDER_CLASS_DEFAULT = DefaultCredentialsProvider.class;
    public static final String CREDENTIALS_PROVIDER_CONFIG_PREFIX = "sqs.credentials.provider.class".substring(0, "sqs.credentials.provider.class".lastIndexOf(".") + 1);
    public static final String TOPIC_CONFIG = "kafka.topic";
    public static final String SQS_URL_CONFIG = "sqs.url";
    public static final Object SQS_URL_DEFAULT = ConfigDef.NO_DEFAULT_VALUE;
    public static final String SQS_REGION_CONFIG = "sqs.region";
    private static final String SQS_REGION_DOC = "The AWS region for SQS.";
    private static final String SQS_REGION_DISPLAY = "SQS Region";
    private static final String SQS_REGION_DEFAULT = "";
    public static final String SQS_PROXY_URL_CONFIG = "sqs.proxy.url";
    public static final String SQS_PROXY_URL_DEFAULT = "";
    public static final String SQS_PROXY_USER_CONFIG = "sqs.proxy.user";
    public static final String SQS_PROXY_USER_DEFAULT = null;
    public static final String SQS_PROXY_PASS_CONFIG = "sqs.proxy.password";
    public static final Password SQS_PROXY_PASS_DEFAULT = new Password(null);
    public static final String SQS_MESSAGES_MAX_CONFIG = "sqs.messages.max";
    public static final int SQS_MESSAGES_MAX_CONFIG_DEFAULT = 10;
    public static final int SQS_MESSAGES_MAX_CONFIG_MIN = 0;
    public static final int SQS_MESSAGES_MAX_CONFIG_MAX = 10;
    public static final String SQS_WAITTIME_SECONDS_CONFIG = "sqs.waittime.seconds";
    public static final int SQS_WAITTIME_SECONDS_DEFAULT = 20;
    public static final int SQS_WAITTIME_SECONDS_MIN = 0;
    public static final int SQS_WAITTIME_SECONDS_MAX = 20;
    public static final String SQS_MAX_RETRIES_CONFIG = "sqs.max.retries";
    public static final int SQS_MAX_RETRIES_DEFAULT = 3;
    private static final String CREDENTIALS_GROUP = "AWS Credentials";
    private static final String PROXY_GROUP = "Proxy";
    public static final ConfigDef CONFIG = SqsSourceConnectorConfig.newConfigDef();

    public static ConfigDef newConfigDef() {
        ConfigDef configDef = new ConfigDef();
        String group = "SQS";
        int orderInGroup = 0;
        configDef.define(TOPIC_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "The Apache Kafka topic to publish data to. Only a single topic must be specified. Records from one or more AWS SQS queues will be published to this topic.", "Kafka", 1, ConfigDef.Width.LONG, "Kafka Topic Name");
        configDef.define(SQS_URL_CONFIG, ConfigDef.Type.STRING, SQS_URL_DEFAULT, ConfigDef.Importance.HIGH, "Fully qualified AWS SQS URL from which this source connector polls messages.", "SQS", ++orderInGroup, ConfigDef.Width.LONG, "Fully Qualified SQS URL");
        configDef.define(SQS_REGION_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.anyOf((ConfigDef.Validator[])new ConfigDef.Validator[]{Validators.oneStringOf((Iterable)Region.regions().stream().map(Region::id).collect(Collectors.toList()), (boolean)false), Validators.blank()}), ConfigDef.Importance.MEDIUM, SQS_REGION_DOC, "SQS", ++orderInGroup, ConfigDef.Width.LONG, SQS_REGION_DISPLAY);
        configDef.define(SQS_MESSAGES_MAX_CONFIG, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)10), ConfigDef.Importance.LOW, "The maximum number of messages to fetch from AWS SQS in every poll. AWS SQS never returns more messages than this value, however, fewer messages may be returned.", "SQS", ++orderInGroup, ConfigDef.Width.LONG, "Max Number Of Messages");
        configDef.define(SQS_WAITTIME_SECONDS_CONFIG, ConfigDef.Type.INT, (Object)20, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)20), ConfigDef.Importance.LOW, "The duration (in seconds) that the call to SQS waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.", "SQS", ++orderInGroup, ConfigDef.Width.LONG, "Wait Time In Seconds");
        configDef.define(SQS_MAX_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "Max number of retry attempts. In case of a network error, the connector can automatically retry the connection.", "SQS", ++orderInGroup, ConfigDef.Width.LONG, "Max Retries");
        SqsSourceConnectorConfig.addCredentialsConfigs(configDef);
        SqsSourceConnectorConfig.addProxyConfigs(configDef);
        return LicenseConfigUtil.addToConfigDef((ConfigDef)configDef);
    }

    private static void addCredentialsConfigs(ConfigDef config) {
        int orderInGroup = 0;
        config.define(AWS_ACCESS_KEY_ID_CONFIG, ConfigDef.Type.PASSWORD, (Object)AWS_ACCESS_KEY_ID_DEFAULT, ConfigDef.Importance.HIGH, AWS_ACCESS_KEY_ID_DOC, CREDENTIALS_GROUP, ++orderInGroup, ConfigDef.Width.LONG, AWS_ACCESS_KEY_ID_DISPLAY).define(AWS_SECRET_KEY_ID_CONFIG, ConfigDef.Type.PASSWORD, (Object)AWS_SECRET_KEY_ID_DEFAULT, ConfigDef.Importance.HIGH, AWS_SECRET_KEY_ID_DOC, CREDENTIALS_GROUP, ++orderInGroup, ConfigDef.Width.LONG, AWS_SECRET_KEY_ID_DISPLAY).define(CREDENTIALS_PROVIDER_CLASS_CONFIG, ConfigDef.Type.CLASS, CREDENTIALS_PROVIDER_CLASS_DEFAULT, (ConfigDef.Validator)new CredentialsProviderValidator(), ConfigDef.Importance.LOW, "Credentials provider or provider chain to use for authentication to AWS. By default the connector uses ``DefaultAWSCredentialsProviderChain``.", CREDENTIALS_GROUP, ++orderInGroup, ConfigDef.Width.LONG, "AWS Credentials Provider Class");
    }

    private static void addProxyConfigs(ConfigDef config) {
        int orderInGroup = 0;
        config.define(SQS_PROXY_URL_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "HTTPS Proxy Server URL. This property is meant to be used only if you need to access SQS through an HTTPS proxy.", PROXY_GROUP, ++orderInGroup, ConfigDef.Width.LONG, "HTTPS Proxy URL").define(SQS_PROXY_USER_CONFIG, ConfigDef.Type.STRING, (Object)SQS_PROXY_USER_DEFAULT, ConfigDef.Importance.LOW, "HTTPS Proxy User. This property is meant to be used only if you need to access SQS through a proxy. Using ``sqs.proxy.user`` instead of embedding the username and password in ``sqs.proxy.url`` allows the password to be hidden in the logs.", PROXY_GROUP, ++orderInGroup, ConfigDef.Width.LONG, "HTTPS Proxy User").define(SQS_PROXY_PASS_CONFIG, ConfigDef.Type.PASSWORD, (Object)SQS_PROXY_PASS_DEFAULT, ConfigDef.Importance.LOW, "HTTPS Proxy Password. This property is meant to be used only if you need to access SQS through a proxy. Using ``sqs.proxy.password`` instead of embedding the username and password in ``sqs.proxy.url`` allows the password to be hidden in the logs.", PROXY_GROUP, ++orderInGroup, ConfigDef.Width.LONG, "HTTPS Proxy Password");
    }

    public AwsCredentialsProvider getCredentialsProvider() throws SqsClientUtil.InvalidCredentialProviderException {
        Password awsAccessKeyId = this.awsAccessKeyId();
        Password awsSecretKeyId = this.awsSecretKeyId();
        if (awsAccessKeyId != null && awsSecretKeyId != null) {
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)awsAccessKeyId.value(), (String)awsSecretKeyId.value()));
        }
        try {
            return (AwsCredentialsProvider)this.getClass(CREDENTIALS_PROVIDER_CLASS_CONFIG).getMethod("create", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SqsClientUtil.InvalidCredentialProviderException(e);
        }
    }

    public String region() {
        return this.getString(SQS_REGION_CONFIG).isEmpty() ? RegionUtil.extractRegion(this.getString(SQS_URL_CONFIG)) : this.getString(SQS_REGION_CONFIG);
    }

    public Password awsAccessKeyId() {
        return this.getPassword(AWS_ACCESS_KEY_ID_CONFIG);
    }

    public Password awsSecretKeyId() {
        return this.getPassword(AWS_SECRET_KEY_ID_CONFIG);
    }

    public SqsSourceConnectorConfig(Map<?, ?> originals) {
        super(CONFIG, originals);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toEnrichedRst());
    }

    private static class CredentialsProviderValidator
    implements ConfigDef.Validator {
        private CredentialsProviderValidator() {
        }

        public void ensureValid(String name, Object provider) {
            if (provider instanceof Class && AwsCredentialsProvider.class.isAssignableFrom((Class)provider)) {
                return;
            }
            throw new ConfigException(name, provider, "Class must extend: " + AwsCredentialsProvider.class);
        }

        public String toString() {
            return "Any class implementing: " + AwsCredentialsProvider.class;
        }
    }
}

