/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.source;

import io.confluent.connect.sqs.source.SqsSourceConfigValidation;
import io.confluent.connect.sqs.source.SqsSourceConnectorConfig;
import io.confluent.connect.sqs.source.SqsSourceTask;
import io.confluent.connect.utils.Version;
import io.confluent.connect.utils.licensing.ConnectLicenseManager;
import io.confluent.connect.utils.licensing.LicenseConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(SqsSourceConnector.class);
    SqsSourceConnectorConfig config;
    ConnectLicenseManager licenseManager;

    public String version() {
        return Version.forClass(((Object)((Object)this)).getClass());
    }

    public void start(Map<String, String> props) {
        this.config = new SqsSourceConnectorConfig(props);
        this.licenseManager = LicenseConfigUtil.createLicenseManager((AbstractConfig)this.config);
        this.doStart();
    }

    void doStart() {
        log.info("Starting AWS SQS Source Connector");
        this.licenseManager.registerOrValidateLicense();
    }

    public Class<? extends Task> taskClass() {
        return SqsSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        HashMap taskProps = new HashMap(this.config.originalsStrings());
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(taskProps);
        }
        return configs;
    }

    public void stop() {
        log.info("Stopping AWS SQS Source Connector");
    }

    public ConfigDef config() {
        return SqsSourceConnectorConfig.CONFIG;
    }

    public Config validate(Map<String, String> connectorConfigs) {
        return new SqsSourceConfigValidation(this.config(), connectorConfigs).validate();
    }
}

