/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.source;

import io.confluent.connect.sqs.source.SqsSourceConnectorConfig;
import io.confluent.connect.sqs.util.SqsClientUtil;
import io.confluent.connect.utils.validators.all.ConfigValidation;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.SqsException;

public class SqsSourceConfigValidation
extends ConfigValidation {
    private SqsSourceConnectorConfig connectorConfig;
    private boolean usingAwsCredentialsFromConfig;
    private SqsAsyncClient client;
    private static final Logger log = LoggerFactory.getLogger(SqsSourceConfigValidation.class);
    public static final String INVALID_ACCESS_KEY_ERROR_CODE = "InvalidClientTokenId";
    public static final String INVALID_SECRET_KEY_ERROR_CODE = "SignatureDoesNotMatch";
    public static final String EXPIRED_CREDENTIALS_ERROR_CODE = "ExpiredToken";
    public static final String INSUFFICIENT_PERMISSIONS_ERROR_CODE = "AccessDenied";
    public static final String RECEIPT_HANDLE_INVALID_ERROR_CODE = "ReceiptHandleIsInvalid";
    public static final String INVALID_ADDRESS_ERROR_CODE = "InvalidAddress";
    public static final String QUEUE_DOES_NOT_EXIST_MESSAGE = "The specified Amazon SQS queue could not be found";
    public static final String INVALID_ACCESS_KEY_MESSAGE = "The provided AWS Access Key is invalid";
    public static final String INVALID_SECRET_KEY_MESSAGE = "The provided AWS Secret Key is invalid";
    public static final String EXPIRED_CREDENTIALS_ERROR_MESSAGE = "The provided credentials have expired";
    public static final String RECEIVE_PERMISSIONS_MISSING_MESSAGE = "The provided credentials don't have permission for the action sqs:ReceiveMessage";
    public static final String DELETE_PERMISSIONS_MISSING_MESSAGE = "The provided credentials don't have permission for the action sqs:DeleteMessage";
    public static final String COULD_NOT_CONNECT_TO_SQS = "Could not connect to your Amazon SQS queue";
    public static final String COULD_NOT_INFER_REGION = "The AWS region could not be inferred from the provided SQS URL. Please also provide the config sqs.region";

    public SqsSourceConfigValidation(ConfigDef configDef, Map<String, String> connectorConfigs) {
        super(configDef, connectorConfigs, new ConfigValidation.ConfigValidator[0]);
    }

    SqsSourceConfigValidation(ConfigDef configDef, Map<String, String> connectorConfigs, SqsAsyncClient client) {
        super(configDef, connectorConfigs, new ConfigValidation.ConfigValidator[0]);
        this.client = client;
    }

    /*
     * Loose catch block
     */
    protected void performValidation() {
        block18: {
            try {
                try {
                    this.connectorConfig = new SqsSourceConnectorConfig(this.originals());
                }
                catch (ConfigException e) {
                    log.error("Individual config validation failed", (Throwable)e);
                    if (this.client != null) {
                        this.client.close();
                    }
                    return;
                }
                boolean bl = this.usingAwsCredentialsFromConfig = this.connectorConfig.awsAccessKeyId() != null && this.connectorConfig.awsSecretKeyId() != null;
                if (this.client == null) {
                    try {
                        this.client = SqsClientUtil.createAsyncClient(this.connectorConfig);
                    }
                    catch (SqsClientUtil.UnableToInferSqsRegionException e) {
                        log.error(COULD_NOT_INFER_REGION, e.getCause());
                        this.recordError(COULD_NOT_INFER_REGION, "sqs.url");
                        if (this.client != null) {
                            this.client.close();
                        }
                        return;
                    }
                    catch (SqsClientUtil.InvalidCredentialProviderException e) {
                        block17: {
                            log.error("Unable to invoke static method create()", e.getCause());
                            this.recordError("Unable to invoke static method create()", "sqs.credentials.provider.class");
                            if (this.client == null) break block17;
                            this.client.close();
                        }
                        return;
                    }
                }
                if (!this.checkReceiveMessagePermission()) {
                    return;
                }
                this.checkDeleteMessagePermission();
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.client != null) {
                    this.client.close();
                }
            }
        }
    }

    private boolean checkReceiveMessagePermission() {
        ReceiveMessageRequest request = (ReceiveMessageRequest)ReceiveMessageRequest.builder().queueUrl(this.connectorConfig.getString("sqs.url")).waitTimeSeconds(Integer.valueOf(1)).visibilityTimeout(Integer.valueOf(1)).maxNumberOfMessages(Integer.valueOf(1)).build();
        CompletableFuture future = this.client.receiveMessage(request);
        try {
            this.handleFuture(future);
        }
        catch (QueueDoesNotExistException e) {
            log.error(QUEUE_DOES_NOT_EXIST_MESSAGE, (Throwable)e);
            this.recordError(QUEUE_DOES_NOT_EXIST_MESSAGE, "sqs.url");
            return false;
        }
        catch (SqsException e) {
            switch (String.valueOf(e.awsErrorDetails().errorCode())) {
                case "InvalidAddress": {
                    log.error(QUEUE_DOES_NOT_EXIST_MESSAGE, (Throwable)e);
                    this.recordError(QUEUE_DOES_NOT_EXIST_MESSAGE, "sqs.url");
                    break;
                }
                case "InvalidClientTokenId": {
                    log.error(INVALID_ACCESS_KEY_MESSAGE, (Throwable)e);
                    this.recordCredentialsError(INVALID_ACCESS_KEY_MESSAGE, "aws.access.key.id");
                    break;
                }
                case "SignatureDoesNotMatch": {
                    log.error(INVALID_SECRET_KEY_MESSAGE, (Throwable)e);
                    this.recordCredentialsError(INVALID_SECRET_KEY_MESSAGE, "aws.secret.key.id");
                    break;
                }
                case "ExpiredToken": {
                    log.error(EXPIRED_CREDENTIALS_ERROR_CODE, (Throwable)e);
                    this.recordCredentialsError(EXPIRED_CREDENTIALS_ERROR_MESSAGE, "aws.access.key.id", "aws.secret.key.id");
                    break;
                }
                case "AccessDenied": {
                    log.error(RECEIVE_PERMISSIONS_MISSING_MESSAGE, (Throwable)e);
                    this.recordCredentialsError(RECEIVE_PERMISSIONS_MISSING_MESSAGE, "aws.access.key.id", "aws.secret.key.id");
                    break;
                }
                default: {
                    log.error(COULD_NOT_CONNECT_TO_SQS, (Throwable)e);
                    this.recordError(COULD_NOT_CONNECT_TO_SQS, "sqs.url");
                    this.recordCredentialsError(COULD_NOT_CONNECT_TO_SQS, "aws.access.key.id", "aws.secret.key.id");
                }
            }
            return false;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof UnknownHostException) {
                log.error(QUEUE_DOES_NOT_EXIST_MESSAGE, e);
                this.recordError(QUEUE_DOES_NOT_EXIST_MESSAGE, "sqs.url");
            } else {
                log.error(COULD_NOT_CONNECT_TO_SQS, e);
                this.recordError(COULD_NOT_CONNECT_TO_SQS, "sqs.url");
                this.recordCredentialsError(COULD_NOT_CONNECT_TO_SQS, "aws.access.key.id", "aws.secret.key.id");
            }
            return false;
        }
        return true;
    }

    private void handleFuture(CompletableFuture<?> future) throws Throwable {
        try {
            future.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private boolean checkDeleteMessagePermission() {
        DeleteMessageRequest deleteMessageRequest = (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(this.connectorConfig.getString("sqs.url")).receiptHandle("dummy_receipt_handle").build();
        CompletableFuture future = this.client.deleteMessage(deleteMessageRequest);
        try {
            this.handleFuture(future);
        }
        catch (SqsException e) {
            String errorCode = e.awsErrorDetails().errorCode();
            if (INSUFFICIENT_PERMISSIONS_ERROR_CODE.equals(errorCode)) {
                log.error(DELETE_PERMISSIONS_MISSING_MESSAGE, (Throwable)e);
                this.recordCredentialsError(DELETE_PERMISSIONS_MISSING_MESSAGE, "aws.access.key.id", "aws.secret.key.id");
            } else {
                if (RECEIPT_HANDLE_INVALID_ERROR_CODE.equals(errorCode)) {
                    return true;
                }
                log.error(COULD_NOT_CONNECT_TO_SQS, (Throwable)e);
                this.recordError(COULD_NOT_CONNECT_TO_SQS, "sqs.url");
                this.recordCredentialsError(COULD_NOT_CONNECT_TO_SQS, "aws.access.key.id", "aws.secret.key.id");
            }
        }
        catch (Throwable e) {
            log.error(COULD_NOT_CONNECT_TO_SQS, e);
            this.recordError(COULD_NOT_CONNECT_TO_SQS, "sqs.url");
            this.recordCredentialsError(COULD_NOT_CONNECT_TO_SQS, "aws.access.key.id", "aws.secret.key.id");
        }
        return true;
    }

    private void recordCredentialsError(String errorMessage, String ... credentialConfigs) {
        if (this.usingAwsCredentialsFromConfig) {
            this.recordErrors(errorMessage, credentialConfigs);
        } else {
            this.recordError(errorMessage, "sqs.credentials.provider.class");
        }
    }
}

