/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.sqs.source;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;

class SqsMessageConverter {
    private static final Schema KEY_SCHEMA = SqsMessageConverter.getKeySchema();
    private static final Schema VALUE_SCHEMA = SqsMessageConverter.getValueSchema();
    static final String FIELD_BODY = "Body";
    static final String FIELD_QUEUE_URL = "QueueUrl";
    static final String FIELD_MESSAGE_ID = "MessageId";
    static final String FIELD_MESSAGE_GROUP_ID = "MessageGroupId";
    private final String sqsQueueUrl;
    private final String topic;
    private final Map<String, String> sourcePartition;

    public SqsMessageConverter(String sqsQueueUrl, String topic) {
        this.sqsQueueUrl = sqsQueueUrl;
        this.topic = topic;
        this.sourcePartition = Collections.singletonMap("SqsQueueUrl", sqsQueueUrl);
    }

    private static Schema getKeySchema() {
        return SchemaBuilder.struct().version(Integer.valueOf(1)).field(FIELD_QUEUE_URL, Schema.STRING_SCHEMA).field(FIELD_MESSAGE_ID, Schema.STRING_SCHEMA).field(FIELD_MESSAGE_GROUP_ID, Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    private static Schema getValueSchema() {
        return SchemaBuilder.struct().version(Integer.valueOf(1)).field(MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP.toString(), Schema.INT64_SCHEMA).field(MessageSystemAttributeName.APPROXIMATE_RECEIVE_COUNT.toString(), Schema.INT32_SCHEMA).field(MessageSystemAttributeName.SENDER_ID.toString(), Schema.STRING_SCHEMA).field(MessageSystemAttributeName.SENT_TIMESTAMP.toString(), Schema.INT64_SCHEMA).field(MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID.toString(), Schema.OPTIONAL_STRING_SCHEMA).field(MessageSystemAttributeName.MESSAGE_GROUP_ID.toString(), Schema.OPTIONAL_STRING_SCHEMA).field(MessageSystemAttributeName.SEQUENCE_NUMBER.toString(), Schema.OPTIONAL_STRING_SCHEMA).field(FIELD_BODY, Schema.STRING_SCHEMA).build();
    }

    SourceRecord convertToRecord(Message message) {
        HashMap<String, String> sourceOffset = new HashMap<String, String>();
        sourceOffset.put("MESSAGE_RECEIPT_HANDLE", message.receiptHandle());
        Integer partition = null;
        Iterable<Header> headers = this.extractHeaders(message.messageAttributes());
        Struct key = this.extractKey(this.sqsQueueUrl, message);
        Struct value = this.extractValue(message);
        long timestamp = this.extractTimestamp(message);
        return new SourceRecord(this.sourcePartition, sourceOffset, this.topic, partition, KEY_SCHEMA, (Object)key, VALUE_SCHEMA, (Object)value, Long.valueOf(timestamp), headers);
    }

    private Iterable<Header> extractHeaders(Map<String, MessageAttributeValue> messageAttributes) {
        if (messageAttributes == null) {
            return null;
        }
        ConnectHeaders headers = new ConnectHeaders();
        for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
            String key = entry.getKey();
            MessageAttributeValue value = entry.getValue();
            this.appendHeader(headers, key, value);
        }
        return headers;
    }

    private void appendHeader(ConnectHeaders headers, String key, MessageAttributeValue value) {
        Schema schema = null;
        Object val = null;
        String dataType = value.dataType();
        if (dataType.startsWith("String") || dataType.startsWith("Number")) {
            schema = Schema.STRING_SCHEMA;
            val = value.stringValue();
        } else if (dataType.startsWith("Binary")) {
            schema = Schema.BYTES_SCHEMA;
            val = value.binaryValue().asByteBuffer();
        }
        if (schema != null && val != null) {
            headers.add(key, val, schema);
        }
    }

    private Struct extractKey(String queueUrl, Message message) {
        return new Struct(KEY_SCHEMA).put(FIELD_QUEUE_URL, (Object)queueUrl).put(FIELD_MESSAGE_ID, (Object)message.messageId()).put(FIELD_MESSAGE_GROUP_ID, message.attributes().get(MessageSystemAttributeName.MESSAGE_GROUP_ID));
    }

    private Struct extractValue(Message message) {
        Map attributes = message.attributes();
        long approximateFirstReceiveTimestamp = SqsMessageConverter.readTimestamp(attributes, MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP, -1L);
        int approximateReceiveCount = SqsMessageConverter.readInt(attributes, MessageSystemAttributeName.APPROXIMATE_RECEIVE_COUNT, 0);
        long sentTimestamp = SqsMessageConverter.readTimestamp(attributes, MessageSystemAttributeName.SENT_TIMESTAMP, -1L);
        return new Struct(VALUE_SCHEMA).put(MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP.toString(), (Object)approximateFirstReceiveTimestamp).put(MessageSystemAttributeName.APPROXIMATE_RECEIVE_COUNT.toString(), (Object)approximateReceiveCount).put(MessageSystemAttributeName.SENDER_ID.toString(), attributes.get(MessageSystemAttributeName.SENDER_ID)).put(MessageSystemAttributeName.SENT_TIMESTAMP.toString(), (Object)sentTimestamp).put(MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID.toString(), attributes.get(MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID)).put(MessageSystemAttributeName.MESSAGE_GROUP_ID.toString(), attributes.get(MessageSystemAttributeName.MESSAGE_GROUP_ID)).put(MessageSystemAttributeName.SEQUENCE_NUMBER.toString(), attributes.get(MessageSystemAttributeName.SEQUENCE_NUMBER)).put(FIELD_BODY, (Object)message.body());
    }

    private long extractTimestamp(Message message) {
        Map attributes = message.attributes();
        return SqsMessageConverter.readTimestamp(attributes, MessageSystemAttributeName.SENT_TIMESTAMP, -1L);
    }

    private static int readInt(Map<MessageSystemAttributeName, String> attributes, MessageSystemAttributeName key, int defaultValue) {
        if (attributes.containsKey(key)) {
            return Integer.parseInt(attributes.get(key));
        }
        return defaultValue;
    }

    private static long readTimestamp(Map<MessageSystemAttributeName, String> attributes, MessageSystemAttributeName key, long defaultValue) {
        if (attributes.containsKey(key)) {
            return Long.parseLong(attributes.get(key));
        }
        return defaultValue;
    }
}

