/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators.template;

import io.confluent.connect.utils.validators.template.Resolution;
import java.util.Map;
import java.util.Objects;

@FunctionalInterface
public interface VariableResolver<T> {
    public static <T> VariableResolver<T> using(String variableName, T value) {
        return (varName, variable, parsed) -> varName.equals(variableName) ? Resolution.with(value) : Resolution.unresolved();
    }

    public static <T> VariableResolver<T> using(Map<String, T> valuesByVariableName) {
        Objects.requireNonNull(valuesByVariableName);
        return (varName, variable, parsed) -> valuesByVariableName.containsKey(varName) ? Resolution.with(valuesByVariableName.get(varName)) : Resolution.unresolved();
    }

    public Resolution<T> resolveVariable(String var1, String var2, Object var3);

    default public VariableResolver<T> then(VariableResolver<T> secondary) {
        Objects.requireNonNull(secondary);
        VariableResolver primary = this;
        return (varName, variable, parsed) -> {
            Resolution result = primary.resolveVariable(varName, variable, parsed);
            if (result.isResolved()) {
                return result;
            }
            return secondary.resolveVariable(varName, variable, parsed);
        };
    }
}

