/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators.template;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.collect.ImmutableSet;
import io.confluent.connect.utils.validators.template.Resolution;
import io.confluent.connect.utils.validators.template.VariableResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Template {
    protected static final Template EMPTY_TEMPLATE = new LiteralTemplate();

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public int variableCount() {
        return this.variableNames().size();
    }

    public boolean hasVariables() {
        return this.variableCount() != 0;
    }

    public boolean isOneVariableOnly() {
        return this.variableCount() == 1 && this.size() == 1;
    }

    public abstract Set<String> variableNames();

    public abstract Template replace(VariableResolver<String> var1);

    public abstract String replaceVariables(VariableResolver<String> var1);

    public abstract <T> Resolution<T> resolveFirstVariableValue(VariableResolver<T> var1);

    protected static class MixedTemplate
    extends Template {
        private final List<Replacement> replacements;
        private final List<Replacement> variableReplacements;
        private final Set<String> variableNames;

        protected MixedTemplate(List<Replacement> replacements) {
            this.replacements = Objects.requireNonNull(replacements);
            this.variableReplacements = replacements.stream().filter(replacement -> !replacement.isLiteral()).collect(Collectors.toList());
            this.variableNames = ImmutableSet.copyOf(this.variableReplacements.stream().map(Replacement::variableName).collect(Collectors.toSet()));
        }

        @Override
        public int size() {
            return this.replacements.size();
        }

        @Override
        public int variableCount() {
            return this.variableReplacements.size();
        }

        @Override
        public Set<String> variableNames() {
            return this.variableNames;
        }

        @Override
        public Template replace(VariableResolver<String> variableResolver) {
            Builder builder = MixedTemplate.builder();
            this.replacements.forEach(replacement -> {
                Resolution<Object> resolution = replacement.getReplacement(variableResolver);
                if (resolution.isResolved()) {
                    String resolvedStr = resolution.map(Object::toString).orElse("");
                    builder.addLiteral(resolvedStr);
                } else {
                    builder.addReplacement((Replacement)replacement);
                }
            });
            return builder.build();
        }

        @Override
        public String replaceVariables(VariableResolver<String> variableResolver) {
            StringBuilder sb = new StringBuilder();
            this.replacements.forEach(replacement -> {
                Object str = replacement.getReplacementOrVariable(variableResolver);
                if (str != null) {
                    sb.append(str.toString());
                }
            });
            return sb.toString();
        }

        @Override
        public <T> Resolution<T> resolveFirstVariableValue(VariableResolver<T> variableResolver) {
            return this.variableReplacements.get(0).getReplacement(variableResolver);
        }

        public String toString() {
            return this.replacements.stream().map(Object::toString).collect(Collectors.joining(""));
        }
    }

    protected static class SingleVariableTemplate
    extends Template {
        private final VariableReplacement variableReplacement;
        private final Set<String> variableNames;

        protected SingleVariableTemplate(VariableReplacement replacement) {
            this.variableReplacement = Objects.requireNonNull(replacement);
            this.variableNames = ImmutableSet.of(this.variableReplacement.variableName());
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Set<String> variableNames() {
            return this.variableNames;
        }

        @Override
        public Template replace(VariableResolver<String> variableResolver) {
            Resolution<String> resolution = this.variableReplacement.getReplacement(variableResolver);
            if (resolution.isResolved()) {
                String resolvedStr = resolution.map(Object::toString).orElse("");
                return new LiteralTemplate(new Literal(resolvedStr));
            }
            return this;
        }

        @Override
        public String replaceVariables(VariableResolver<String> variableResolver) {
            Object result = this.variableReplacement.getReplacementOrVariable(variableResolver);
            return result == null ? null : result.toString();
        }

        @Override
        public <T> Resolution<T> resolveFirstVariableValue(VariableResolver<T> variableResolver) {
            return this.variableReplacement.getReplacement(variableResolver);
        }

        public String toString() {
            return this.variableReplacement.toString();
        }
    }

    protected static class LiteralTemplate
    extends Template {
        private final Literal replacement;
        private final String strValue;

        protected LiteralTemplate() {
            this.replacement = null;
            this.strValue = "";
        }

        protected LiteralTemplate(Literal replacement) {
            this.replacement = Objects.requireNonNull(replacement);
            this.strValue = replacement.toString();
        }

        @Override
        public int size() {
            return this.replacement != null ? 1 : 0;
        }

        @Override
        public Set<String> variableNames() {
            return Collections.emptySet();
        }

        @Override
        public Template replace(VariableResolver<String> variableResolver) {
            return this;
        }

        @Override
        public String replaceVariables(VariableResolver<String> variableResolver) {
            return this.strValue;
        }

        @Override
        public <T> Resolution<T> resolveFirstVariableValue(VariableResolver<T> variableResolver) {
            return Resolution.unresolved();
        }

        public String toString() {
            return this.strValue;
        }
    }

    public static class Builder {
        private final List<Replacement> replacements = new ArrayList<Replacement>();

        public Builder addVariable(String variableName) {
            return this.addVariable(variableName, variableName, variableName);
        }

        public Builder addVariable(String variableName, String variable) {
            return this.addReplacement(new VariableReplacement(variableName, variable, variable));
        }

        public Builder addVariable(String variableName, String variable, Object parsed) {
            return this.addReplacement(new VariableReplacement(variableName, variable, parsed));
        }

        public Builder addLiteral(String substring) {
            return this.addReplacement(new Literal(substring));
        }

        protected Builder addReplacement(Replacement replacement) {
            int lastIndex;
            Replacement last;
            assert (replacement != null);
            if (replacement.isLiteral() && !this.replacements.isEmpty() && (last = this.replacements.get(lastIndex = this.replacements.size() - 1)).isLiteral()) {
                Literal newReplacement = new Literal(last.toString() + replacement.toString());
                this.replacements.set(lastIndex, newReplacement);
                return this;
            }
            this.replacements.add(replacement);
            return this;
        }

        public Builder trim() {
            if (!this.replacements.isEmpty() && this.replacements.get(0).isLiteral()) {
                Literal first = (Literal)this.replacements.get(0);
                String result = Strings.removeLeadingWhitespace(first.toString());
                if (result.isEmpty()) {
                    this.replacements.remove(0);
                } else {
                    this.replacements.set(0, new Literal(result));
                }
            }
            int lastIndex = this.replacements.size() - 1;
            if (!this.replacements.isEmpty() && this.replacements.get(lastIndex).isLiteral()) {
                Literal last = (Literal)this.replacements.get(lastIndex);
                String result = Strings.removeTrailingWhitespace(last.toString());
                if (result.isEmpty()) {
                    this.replacements.remove(lastIndex);
                } else {
                    this.replacements.set(lastIndex, new Literal(result));
                }
            }
            return this;
        }

        public Template build() {
            if (this.replacements.isEmpty()) {
                return EMPTY_TEMPLATE;
            }
            if (this.replacements.size() == 1) {
                Replacement replacement = this.replacements.get(0);
                if (replacement.isLiteral()) {
                    Literal literal = (Literal)replacement;
                    return new LiteralTemplate(literal);
                }
                VariableReplacement var = (VariableReplacement)replacement;
                return new SingleVariableTemplate(var);
            }
            return new MixedTemplate(this.replacements);
        }
    }

    protected static class VariableReplacement
    implements Replacement {
        private final String variableName;
        private final String variable;
        private final Object parsed;

        protected VariableReplacement(String variableName, String variable, Object parsed) {
            this.variableName = Objects.requireNonNull(variableName);
            this.variable = Objects.requireNonNull(variable);
            this.parsed = Objects.requireNonNull(parsed);
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public String variableName() {
            return this.variableName;
        }

        @Override
        public String variable() {
            return this.variable;
        }

        @Override
        public <T> Resolution<T> getReplacement(VariableResolver<T> resolver) {
            return resolver.resolveVariable(this.variableName, this.variable, this.parsed);
        }

        public String toString() {
            if (!Objects.equals(this.parsed, this.variable)) {
                return String.format("${%s} as %s", this.variable, this.parsed);
            }
            return String.format("${%s}", this.variable);
        }
    }

    protected static class Literal
    implements Replacement {
        private final Resolution<String> literal;

        protected Literal(String literal) {
            this.literal = Resolution.with(Objects.requireNonNull(literal));
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public String variableName() {
            return null;
        }

        @Override
        public String variable() {
            return null;
        }

        public Resolution<?> getReplacement(VariableResolver resolver) {
            return this.literal;
        }

        public String toString() {
            return this.literal.get();
        }
    }

    static interface Replacement {
        public boolean isLiteral();

        public String variableName();

        public String variable();

        public <T> Resolution<T> getReplacement(VariableResolver<T> var1);

        default public Object getReplacementOrVariable(VariableResolver<?> resolver) {
            Resolution<?> resolution = this.getReplacement(resolver);
            if (resolution.isResolved()) {
                return resolution.get();
            }
            return String.format("${%s}", this.variable());
        }
    }
}

