/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators.template;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Resolution<T> {
    private static final Object UNRESOLVED_VALUE = new Object();
    public static final Resolution<?> UNRESOLVED = new Resolution<Object>(UNRESOLVED_VALUE);
    private final T value;

    public static <T> Resolution<T> unresolved() {
        Resolution<?> t = UNRESOLVED;
        return t;
    }

    public static <T> Resolution<T> with(T value) {
        return new Resolution<T>(value);
    }

    private Resolution() {
        this.value = null;
    }

    private Resolution(T value) {
        this.value = value;
    }

    public boolean isResolved() {
        return this.value != UNRESOLVED_VALUE;
    }

    public void ifResolved(Consumer<? super T> consumer) {
        if (this.isResolved()) {
            consumer.accept(this.value);
        }
    }

    public T get() {
        if (this.isResolved()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public T orElse(T other) {
        return this.isResolved() ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isResolved() ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isResolved()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <U> Resolution<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isResolved()) {
            return Resolution.unresolved();
        }
        return Resolution.with(mapper.apply(this.value));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Resolution)) {
            return false;
        }
        Resolution other = (Resolution)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.isResolved() ? String.format("Resolution[%s]", this.value) : "Resolution.unresolved";
    }
}

