/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators.all;

import io.confluent.connect.utils.validators.all.ConfigValidationCheck;
import io.confluent.connect.utils.validators.all.NoOpValidationCheck;
import java.util.Optional;
import java.util.concurrent.Callable;

public interface ConfigValidationResult {
    public boolean isValid(String var1);

    default public boolean isNotValid(String key) {
        return !this.isValid(key);
    }

    default public boolean areEachValid(String ... keys) {
        for (String key : keys) {
            if (this.isValid(key)) continue;
            return false;
        }
        return true;
    }

    default public boolean areAnyNotValid(String ... keys) {
        return !this.areEachValid(keys);
    }

    public void recordError(String var1, String var2);

    default public void recordErrors(String message, String ... keys) {
        for (String key : keys) {
            this.recordError(message, key);
        }
    }

    default public ValidationOperation whenValid(String key) {
        if (this.isValid(key)) {
            return new ConfigValidationCheck(new String[]{key}, this);
        }
        return NoOpValidationCheck.INSTANCE;
    }

    default public ValidationOperation whenEachAreValid(String ... keys) {
        if (this.areEachValid(keys)) {
            return new ConfigValidationCheck(keys, this);
        }
        return NoOpValidationCheck.INSTANCE;
    }

    public static interface ValidationOperation {
        public void then(Runnable var1);

        public <T> Optional<T> thenReturn(Callable<T> var1);
    }
}

