/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators.all;

import io.confluent.connect.utils.validators.all.ConfigValidationResult;
import java.util.Optional;
import java.util.concurrent.Callable;

class ConfigValidationCheck
implements ConfigValidationResult.ValidationOperation {
    private final String[] keys;
    private final ConfigValidationResult result;

    ConfigValidationCheck(String[] keys, ConfigValidationResult result) {
        this.keys = keys;
        this.result = result;
    }

    @Override
    public void then(Runnable check) {
        try {
            check.run();
        }
        catch (Exception e) {
            this.result.recordErrors(e.getMessage(), this.keys);
        }
    }

    @Override
    public <T> Optional<T> thenReturn(Callable<T> check) {
        try {
            return Optional.of(check.call());
        }
        catch (Exception e) {
            this.result.recordErrors(e.getMessage(), this.keys);
            return Optional.empty();
        }
    }
}

