/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators.all;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.collect.ImmutableList;
import io.confluent.connect.utils.collect.ImmutableMap;
import io.confluent.connect.utils.validators.all.ConfigValidationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;

public class ConfigValidation
implements ConfigValidationResult {
    protected final ConfigDef configDef;
    protected final List<ConfigValidator> validators;
    protected final Map<String, String> originals;
    protected final Map<String, ConfigValue> valuesByKey = new HashMap<String, ConfigValue>();
    protected final Map<String, Object> parsedConfig = new LinkedHashMap<String, Object>();

    public ConfigValidation(ConfigDef configDef, Map<String, String> connectorConfigs, ConfigValidator ... validators) {
        this.configDef = Objects.requireNonNull(configDef);
        this.originals = ImmutableMap.copyOf(Objects.requireNonNull(connectorConfigs));
        this.validators = ImmutableList.of((Object[])Objects.requireNonNull(validators));
        if (this.validators.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("The config validator references may not be null");
        }
    }

    public final Config validate() {
        this.validateIndividualConfigs();
        this.callValidators();
        this.performValidation();
        List configValues = this.valuesByKey.values().stream().collect(Collectors.toList());
        return new Config(configValues);
    }

    protected void validateIndividualConfigs() {
        this.configDef.validate(this.originals()).stream().filter(Objects::nonNull).forEach(this::addConfigValue);
    }

    protected void addConfigValue(ConfigValue value) {
        this.valuesByKey.put(value.name(), value);
        this.parsedConfig.put(value.name(), value.value());
    }

    protected void callValidators() {
        this.validators.stream().forEach(validator -> validator.ensureValid(this.parsedConfig, this));
    }

    protected void performValidation() {
    }

    protected ConfigValue newConfigValue(String key) {
        return new ConfigValue(key, (Object)this.originals().get(key), new ArrayList(), new ArrayList());
    }

    protected Map<String, String> originals() {
        return this.originals;
    }

    @Override
    public void recordError(String message, String key) {
        Objects.requireNonNull(key);
        if (Strings.isNotBlank(key)) {
            ConfigValue value = this.valuesByKey.computeIfAbsent(key, this::newConfigValue);
            if (Strings.isNotBlank(message)) {
                value.addErrorMessage(message);
            }
        }
    }

    @Override
    public boolean isValid(String key) {
        ConfigValue value = this.valuesByKey.get(key);
        return value == null || value.errorMessages().isEmpty();
    }

    @FunctionalInterface
    public static interface ConfigValidator {
        public void ensureValid(Map<String, Object> var1, ConfigValidationResult var2);
    }
}

