/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.collect.ImmutableList;
import io.confluent.connect.utils.validators.Validators;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.kafka.common.config.ConfigException;

class UriValidator
extends Validators.SingleOrListValidator {
    protected List<String> validSchemes;

    protected UriValidator(String ... validSchemes) {
        this.validSchemes = ImmutableList.copyOf(validSchemes);
    }

    @Override
    protected void validate(String config, Object value) {
        if (value == null) {
            throw new ConfigException(config, value, String.format("URI scheme must be one of the following. '%s'", String.join((CharSequence)"', '", this.validSchemes)));
        }
        try {
            URI uri = new URI(value.toString());
            if (!this.validSchemes.isEmpty() && !this.validSchemes.contains(uri.getScheme())) {
                throw new ConfigException(config, value, String.format("URI scheme must be one of the following. '%s'", String.join((CharSequence)"', '", this.validSchemes)));
            }
        }
        catch (URISyntaxException e) {
            ConfigException configException = new ConfigException(config, value, "Could not parse to URI.");
            configException.initCause((Throwable)e);
            throw configException;
        }
    }

    public String toString() {
        return "URI with one of these schemes: '" + String.join((CharSequence)"', '", this.validSchemes) + "'";
    }
}

