/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigException;

class TopicNameValidator
extends Validators.SingleOrListValidator {
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = 249;
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z0-9+._\\-]{1,249}");

    TopicNameValidator() {
    }

    @Override
    protected void validate(String name, Object value) {
        if (null == value || !(value instanceof String)) {
            throw new ConfigException(name, (Object)"Must be a string and cannot be null.");
        }
        String topicName = value.toString();
        if (topicName.length() < 1) {
            throw new ConfigException(name, value, "topic names may not be empty");
        }
        if (topicName.length() > 249) {
            throw new ConfigException(name, value, String.format("topic names may not be longer than %d characters", 249));
        }
        Matcher matcher = PATTERN.matcher(value.toString());
        if (!matcher.matches()) {
            throw new ConfigException(name, value, "topic names may have 1-249 ASCII alphanumeric, `+`, `.`, `_`, and `-` characters");
        }
    }

    public String toString() {
        return "Valid topic names contain 1-249 ASCII alphanumeric, ``+``, ``.``, ``_`` and ``-`` characters";
    }
}

