/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.kafka.common.config.ConfigException;

class TimeZoneValidator
extends Validators.SingleOrListValidator {
    public static final TimeZoneValidator INSTANCE = new TimeZoneValidator();

    TimeZoneValidator() {
    }

    @Override
    protected void validate(String name, Object value) {
        if (value != null) {
            try {
                ZoneId.of(value.toString());
            }
            catch (DateTimeException e) {
                throw new ConfigException(name, value, String.format("'%s' is not a known time zone identifier", value));
            }
        }
    }

    public String toString() {
        return "Valid timezone name or identifier";
    }
}

