/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import org.apache.kafka.common.config.ConfigException;

class StringLengthValidator
extends Validators.SingleOrListValidator {
    private final int minLength;
    private final int maxLength;

    protected StringLengthValidator(int minLength, int maxLength) {
        if (minLength > maxLength) {
            throw new IllegalArgumentException("Minimum length may not be larger than maximum length");
        }
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    protected void validate(String name, Object value) {
        if (null == value || !(value instanceof String)) {
            throw new ConfigException(name, (Object)"Must be a string and cannot be null.");
        }
        String str = (String)value;
        if (str.length() < this.minLength || str.length() > this.maxLength) {
            throw new ConfigException(name, (Object)String.format("'%s' must have no fewer than %d and no more than %d characters", value, this.minLength, this.maxLength));
        }
    }

    public String toString() {
        return String.format("Must be from %d through %d characters long", this.minLength, this.maxLength);
    }
}

