/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

class StringAsTypeValidator
extends Validators.SingleOrListValidator {
    private final ConfigDef.Type type;
    private final ConfigDef.Validator typeValidator;

    protected StringAsTypeValidator(ConfigDef.Type type, ConfigDef.Validator typeValidator) {
        this.type = Objects.requireNonNull(type);
        this.typeValidator = typeValidator;
    }

    @Override
    protected void validate(String name, Object value) {
        if (null == value || !(value instanceof String)) {
            throw new ConfigException(name, (Object)"Must be a non-null string.");
        }
        Object typedValue = ConfigDef.parseType((String)name, (Object)value, (ConfigDef.Type)this.type);
        if (this.typeValidator != null) {
            this.typeValidator.ensureValid(name, typedValue);
        }
    }

    public String toString() {
        return this.type.toString().toLowerCase();
    }
}

