/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigException;

class RegexValidator
extends Validators.SingleOrListValidator {
    private final Pattern pattern;

    protected RegexValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    protected void validate(String name, Object value) {
        if (null == value || !(value instanceof String)) {
            throw new ConfigException(name, (Object)"Must be a string and cannot be null.");
        }
        Matcher matcher = this.pattern.matcher(value.toString());
        if (!matcher.matches()) {
            throw new ConfigException(name, value, String.format("must match pattern '%s'", this.pattern.pattern()));
        }
    }

    public String toString() {
        return String.format("Matches regex %s", this.pattern.pattern());
    }
}

