/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.collect.ImmutableMap;
import io.confluent.connect.utils.validators.Validators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class MapValidator
extends Validators.SingleOrListValidator {
    private final ConfigDef.Validator keyValidator;
    private final ConfigDef.Validator valueValidator;

    public static <K, V> Map<K, V> parseMap(String value, Function<String, K> keyParser, Function<String, V> valueParser) {
        HashMap result = new HashMap();
        List entries = (List)ConfigDef.parseType((String)"", (Object)value, (ConfigDef.Type)ConfigDef.Type.LIST);
        entries.stream().filter(Strings::isNotBlank).forEach(s -> {
            String[] entry = s.split("=", 2);
            Object key = keyParser.apply(entry[0].trim());
            Object val = valueParser.apply(entry[1].trim());
            result.put(key, val);
        });
        return ImmutableMap.copyOf(result);
    }

    protected MapValidator(ConfigDef.Validator keyValidator, ConfigDef.Validator valueValidator) {
        this.keyValidator = Objects.requireNonNull(keyValidator);
        this.valueValidator = Objects.requireNonNull(valueValidator);
    }

    @Override
    protected void validate(String name, Object value) {
        if (null == value || !(value instanceof String)) {
            throw new ConfigException(name, (Object)"Must be a non-null string.");
        }
        HashSet<String> keys = new HashSet<String>();
        List entries = (List)ConfigDef.parseType((String)name, (Object)value, (ConfigDef.Type)ConfigDef.Type.LIST);
        for (String entry : entries) {
            if (!Strings.isNotBlank(entry)) continue;
            try {
                String[] pair = entry.split("=", 2);
                String key = pair[0].trim();
                String val = pair[1].trim();
                this.keyValidator.ensureValid(name, (Object)key);
                this.valueValidator.ensureValid(name, (Object)val);
                if (keys.add(key)) continue;
                throw new ConfigException(name, value, String.format("key '%s' is specified multiple times", key));
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException(name, value, "Must contain valid key=value pairs separated by ',': " + e.getMessage());
            }
        }
        entries.stream().filter(Strings::isNotBlank).forEach(s -> {});
    }

    public String toString() {
        return String.format("Comma-separated key-value pairs, where keys %s and values %s", this.keyValidator, this.valueValidator);
    }
}

