/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.collect.ImmutableSet;
import io.confluent.connect.utils.validators.PatternDefinition;
import io.confluent.connect.utils.validators.RegexValidator;
import io.confluent.connect.utils.validators.template.Template;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;

public class InterpolatedStringValidator
extends RegexValidator {
    public static final String NON_SUBSTITUTION_CHARACTERS = "[^\\\\${}]";
    public static final String ESCAPED_CHARACTERS = "\\\\.";
    private final String variableNamesList;
    private final Set<String> unquotedVariableNames;
    private final Map<Pattern, PatternDefinition> variableNamePatterns;
    private final Pattern replacePattern;

    private static Pattern getFormatStringPattern(Collection<String> unquotedVariableNames, Collection<String> variableNamePatterns, boolean tokenize) {
        String variableSubstitutionsRegex = "\\$\\{(?:" + InterpolatedStringValidator.join("|", unquotedVariableNames, variableNamePatterns, Pattern::quote) + ")}";
        String formatStringRegex = "(?:[^\\\\${}]+|\\\\.|" + variableSubstitutionsRegex + ")" + (tokenize ? "" : "*");
        return Pattern.compile(formatStringRegex);
    }

    private static String join(CharSequence joinChars, Collection<String> unquotedVariableNames, Collection<String> variableNamePatterns, Function<String, String> quoteFunction) {
        String unquotedVariablesPortion = unquotedVariableNames.stream().map(quoteFunction).collect(Collectors.joining(joinChars));
        String quotedVariablesPortion = variableNamePatterns.stream().collect(Collectors.joining(joinChars));
        return String.join(joinChars, unquotedVariablesPortion, quotedVariablesPortion);
    }

    public static String removeVariableName(String value, String variableNamePlusPrefix, String suffix) {
        if (value.length() < variableNamePlusPrefix.length() + suffix.length()) {
            return value;
        }
        return value.substring(variableNamePlusPrefix.length(), value.length() - suffix.length());
    }

    public static String removeVariableNameAndBrackets(String value, String variableName) {
        return InterpolatedStringValidator.removeVariableName(value, variableName + "[", "]");
    }

    public static String removeSquareBrackets(String value) {
        int index = value.indexOf("[");
        if (index > 0) {
            return value.substring(0, index);
        }
        return value;
    }

    public InterpolatedStringValidator(Collection<String> unquotedVariableNames, Map<String, PatternDefinition> variableNamePatterns) {
        super(InterpolatedStringValidator.getFormatStringPattern(unquotedVariableNames, variableNamePatterns.keySet(), false));
        this.variableNamePatterns = variableNamePatterns.entrySet().stream().map(Objects::requireNonNull).collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey()), e -> (PatternDefinition)e.getValue()));
        this.variableNamesList = InterpolatedStringValidator.join(", ", unquotedVariableNames, variableNamePatterns.keySet(), v -> v);
        this.replacePattern = InterpolatedStringValidator.getFormatStringPattern(unquotedVariableNames, variableNamePatterns.keySet(), true);
        this.unquotedVariableNames = ImmutableSet.copyOf(unquotedVariableNames.stream().collect(Collectors.toSet()));
    }

    @Override
    protected void validate(String name, Object value) {
        try {
            super.validate(name, value);
            String str = value.toString();
            this.variableNamePatterns.entrySet().stream().forEach(e -> this.validatePattern(name, str, (Pattern)e.getKey(), (PatternDefinition)e.getValue()));
        }
        catch (ConfigException e2) {
            throw new ConfigException(name, (Object)("Must contain only valid variable substitutions or characters escaped with `\\`: " + e2.getMessage()));
        }
    }

    @Override
    public String toString() {
        return String.format("optionally includes substitution(s): %s", this.variableNamesList);
    }

    protected void validatePattern(String name, String value, Pattern pattern, PatternDefinition validator) {
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String matchedSubstring = matcher.group();
            validator.validator().ensureValid(name, (Object)matchedSubstring);
        }
    }

    public Template templateFor(String templateString) {
        this.validate("resolver input", templateString);
        Template.Builder builder = Template.builder();
        Matcher matcher = this.replacePattern.matcher(templateString);
        while (matcher.find()) {
            String replaced = matcher.group();
            if (replaced.startsWith("${") && replaced.endsWith("}") && replaced.length() > 3) {
                String variable = replaced.substring(2, replaced.length() - 1);
                if (this.unquotedVariableNames.contains(variable)) {
                    builder.addVariable(variable, variable, variable);
                    continue;
                }
                Optional<PatternDefinition> patternDefn = this.matchingVariablePattern(variable);
                if (patternDefn.isPresent()) {
                    PatternDefinition defn = patternDefn.get();
                    Object parsed = defn.preResolvingParser().apply(variable);
                    String variableName = defn.nameExtractor().apply(variable);
                    builder.addVariable(variableName, variable, parsed);
                    continue;
                }
            }
            builder.addLiteral(replaced);
        }
        return builder.build();
    }

    protected Optional<PatternDefinition> matchingVariablePattern(String str) {
        return this.variableNamePatterns.entrySet().stream().filter(entry -> ((Pattern)entry.getKey()).matcher(str).matches()).map(Map.Entry::getValue).findFirst();
    }
}

