/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;

public class DateTimeValidator
extends Validators.SingleOrListValidator {
    private final Map<String, DateTimeFormatter> formats = new LinkedHashMap<String, DateTimeFormatter>();

    protected DateTimeValidator() {
        this.formats.put("yyyy-MM-dd", DateTimeFormatter.ISO_LOCAL_DATE);
        this.formats.put("yyyy-MM-dd'T'HH:mm:SS", DateTimeFormatter.ISO_DATE_TIME);
        this.formats.put("yyyy-'W'w-6EX", DateTimeFormatter.ISO_WEEK_DATE);
        this.formats.put("yyyy-MM-dd'T'HH:mm:SSV", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    protected DateTimeValidator(String formatName, DateTimeFormatter format) {
        this.formats.put(Objects.requireNonNull(formatName), Objects.requireNonNull(format));
    }

    protected DateTimeValidator(DateTimeFormatter ... formatters) {
        Arrays.stream(formatters).filter(Objects::nonNull).forEach(formatter -> this.formats.put(formatter.toString(), (DateTimeFormatter)formatter));
        if (this.formats.isEmpty()) {
            throw new IllegalArgumentException("At least one non-null formatter must be specified");
        }
    }

    protected DateTimeValidator(String ... formats) {
        Arrays.stream(formats).filter(Objects::nonNull).forEach(format -> this.formats.put((String)format, DateTimeFormatter.ofPattern(format)));
        if (this.formats.isEmpty()) {
            throw new IllegalArgumentException("At least one non-null format must be specified");
        }
    }

    @Override
    protected void validate(String name, Object value) {
        if (null == value || !(value instanceof String)) {
            throw new ConfigException(name, (Object)(Objects.isNull(value) ? "Expected String, found Null" : "Expected String, but found " + value.getClass().getName()));
        }
        boolean allFailed = true;
        for (DateTimeFormatter fmt : this.formats.values()) {
            try {
                fmt.parse((CharSequence)value);
                allFailed = false;
                break;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        if (allFailed) {
            throw new ConfigException(String.format("'%s' having value '%s' must be of ISO 8601 format!", name, value));
        }
    }

    public String toString() {
        if (this.formats.size() == 1) {
            return String.format("timestamp in format ``%s``", this.formats.keySet().stream().findFirst().get());
        }
        String formatStr = this.formats.keySet().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("``, ``", "``", "``"));
        return String.format("timestamp in one of these formats: %s", formatStr);
    }
}

