/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.validators;

import io.confluent.connect.utils.validators.Validators;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;

public class DateTimeFormatValidator
extends Validators.SingleOrListValidator {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final ZoneId DEFAULT_TIME_ZONE = ZoneId.of("UTC");

    public static DateTimeFormatter parseDateTimeFormat(String value) {
        Objects.requireNonNull(value);
        String formatStr = value;
        String[] parts = formatStr.split(",");
        Optional<ZoneId> zoneId = DateTimeFormatValidator.parseTimeZone(parts[0]);
        if (zoneId.isPresent()) {
            formatStr = parts.length == 2 ? parts[1].trim() : DEFAULT_FORMAT;
        } else {
            formatStr = parts[0].trim();
            if (formatStr.isEmpty()) {
                formatStr = DEFAULT_FORMAT;
            }
        }
        try {
            DateTimeFormatter format = DateTimeFormatter.ofPattern(formatStr);
            format = format.withZone(zoneId.orElse(DEFAULT_TIME_ZONE));
            return format;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected static Optional<ZoneId> parseTimeZone(String id) {
        try {
            return Optional.of(ZoneId.of(id.trim()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    protected void validate(String name, Object value) {
        if (value == null || value.toString().trim().isEmpty()) {
            throw new ConfigException(name, value, "Must not be null or blank");
        }
        try {
            DateTimeFormatValidator.parseDateTimeFormat(value.toString());
        }
        catch (Exception e) {
            throw new ConfigException(name, value, "Must follow the Java SimpleDateFormat rules");
        }
    }

    public String toString() {
        return "``<format>`` or ``<zoneId>,<format>`` or ``<zoneId>``, where ``<zoneId>`` is the ID of the time zone in which the timestamps are to be output, and ``<format>`` is the Java DateTimeFormatter format pattern";
    }
}

