/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import io.confluent.connect.utils.schema.InvalidSchemaChangeException;
import io.confluent.connect.utils.schema.SchemaValidator;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class SchemaValidators {
    private static final SchemaValidator NO_VALIDATION = SchemaValidators::checkNothing;
    private static final SchemaValidator SAME_TYPE = SchemaValidators::checkSameType;
    private static final SchemaValidator SAME_NAME = SchemaValidators::checkSameName;
    private static final SchemaValidator SAME_OPTIONALITY = SchemaValidators::checkSameOptionality;
    private static final SchemaValidator EXPAND_NUMERICS = SchemaValidators::checkNumericExpansion;
    private static final SchemaValidator EXPAND_NUMERICS_WITH_DECIMAL = SchemaValidators::checkNumericExpansionWithDecimal;
    private static final SchemaValidator STRING_TO_BYTES = SchemaValidators::checkStringToBytes;
    private static final SchemaValidator SAME_TYPE_AND_OPTIONALITY = SAME_TYPE.and(SAME_OPTIONALITY);
    private static final SchemaValidator SAME_NAME_AND_TYPE_AND_OPTIONALITY = SAME_TYPE_AND_OPTIONALITY.and(SAME_NAME);

    public static SchemaValidator noValidation() {
        return NO_VALIDATION;
    }

    public static SchemaValidator requireSameName() {
        return SAME_NAME;
    }

    public static SchemaValidator requireSameType() {
        return SAME_TYPE;
    }

    public static SchemaValidator allowNumericExpansion() {
        return EXPAND_NUMERICS;
    }

    public static SchemaValidator allowNumericExpansionWithDecimal() {
        return EXPAND_NUMERICS_WITH_DECIMAL;
    }

    public static SchemaValidator allowStringToBytes() {
        return STRING_TO_BYTES;
    }

    public static SchemaValidator requireSameOptionality() {
        return SAME_OPTIONALITY;
    }

    public static SchemaValidator requireSameTypeAndOptionality() {
        return SAME_TYPE_AND_OPTIONALITY;
    }

    public static SchemaValidator requireSameNameAndTypeAndOptionality() {
        return SAME_NAME_AND_TYPE_AND_OPTIONALITY;
    }

    static void failChangingType(Schema newSchema, Schema previous) {
        String msg = previous.name() != null || newSchema.name() != null ? String.format("Cannot change type from %s (%s) to %s (%s)", previous.type(), previous.name(), newSchema.type(), newSchema.name()) : String.format("Cannot change type from %s to %s", previous.type(), newSchema.type());
        throw new InvalidSchemaChangeException(previous, newSchema, msg);
    }

    static void checkSameOptionality(Schema newSchema, Schema previous) {
        if (previous.isOptional() != newSchema.isOptional()) {
            throw new InvalidSchemaChangeException(previous, newSchema, String.format("Cannot change optionality from %s (%s) to %s (%s)", previous.isOptional() ? "optional" : "required", previous.name(), newSchema.isOptional() ? "optional" : "required", newSchema.name()));
        }
    }

    static void checkSameName(Schema newSchema, Schema previous) {
        if (!Objects.equals(previous.name(), newSchema.name())) {
            SchemaValidators.failChangingType(newSchema, previous);
        }
    }

    static void checkNothing(Schema newSchema, Schema previous) {
    }

    static void checkSameType(Schema newSchema, Schema previous) {
        if (previous == newSchema) {
            return;
        }
        if (previous.type() != newSchema.type()) {
            SchemaValidators.failChangingType(newSchema, previous);
        }
        SchemaValidators.checkSameName(newSchema, previous);
        if (SchemaValidators.isDecimal(previous) && SchemaValidators.isDecimal(newSchema)) {
            int previousScale = Integer.parseInt((String)previous.parameters().get("scale"));
            int newScale = Integer.parseInt((String)newSchema.parameters().get("scale"));
            if (newScale != previousScale) {
                throw new InvalidSchemaChangeException(previous, newSchema, String.format("Cannot change decimal scale from %d to %d", previousScale, newScale));
            }
            return;
        }
    }

    static void checkStringToBytes(Schema newSchema, Schema previous) {
        if (previous == newSchema) {
            return;
        }
        if (previous.type() == newSchema.type() && previous.type().isPrimitive() && newSchema.type().isPrimitive()) {
            return;
        }
        switch (previous.type()) {
            case STRING: 
            case BYTES: {
                switch (newSchema.type()) {
                    case STRING: 
                    case BYTES: {
                        return;
                    }
                }
                break;
            }
            case ARRAY: {
                if (newSchema.type() != Schema.Type.ARRAY) {
                    SchemaValidators.failChangingType(newSchema, previous);
                }
                SchemaValidators.checkStringToBytes(newSchema.valueSchema(), previous.valueSchema());
                return;
            }
            case MAP: {
                if (newSchema.type() != Schema.Type.MAP) {
                    SchemaValidators.failChangingType(newSchema, previous);
                }
                SchemaValidators.checkStringToBytes(newSchema.keySchema(), previous.keySchema());
                SchemaValidators.checkStringToBytes(newSchema.valueSchema(), previous.valueSchema());
                return;
            }
            case STRUCT: {
                if (newSchema.type() != Schema.Type.STRUCT) {
                    SchemaValidators.failChangingType(newSchema, previous);
                }
                newSchema.fields().forEach(field -> {
                    Field previousField = previous.field(field.name());
                    if (previousField != null) {
                        SchemaValidators.checkStringToBytes(field.schema(), previousField.schema());
                    }
                });
                return;
            }
        }
        if (newSchema.type() != previous.type()) {
            SchemaValidators.failChangingType(newSchema, previous);
        }
        if (Objects.equals(newSchema.name(), previous.name())) {
            SchemaValidators.failChangingType(newSchema, previous);
        }
    }

    static void checkNumericExpansionWithDecimal(Schema newSchema, Schema previous) {
        SchemaValidators.checkNumericExpansion(newSchema, previous, true);
    }

    static void checkNumericExpansion(Schema newSchema, Schema previous) {
        SchemaValidators.checkNumericExpansion(newSchema, previous, false);
    }

    static void checkNumericExpansion(Schema newSchema, Schema previous, boolean includeDecimal) {
        if (previous == newSchema) {
            return;
        }
        if (previous.type() == newSchema.type() && previous.type().isPrimitive() && newSchema.type().isPrimitive()) {
            return;
        }
        switch (previous.type()) {
            case BYTES: {
                if (!SchemaValidators.isDecimal(previous) || !SchemaValidators.isDecimal(newSchema) || !includeDecimal) break;
                int previousScale = Integer.parseInt((String)previous.parameters().get("scale"));
                int newScale = Integer.parseInt((String)newSchema.parameters().get("scale"));
                if (newScale < previousScale) {
                    throw new InvalidSchemaChangeException(previous, newSchema, String.format("Cannot reduce decimal scale from %d to %d", previousScale, newScale));
                }
                return;
            }
            case BOOLEAN: {
                switch (newSchema.type()) {
                    case BOOLEAN: {
                        return;
                    }
                }
                SchemaValidators.failChangingType(newSchema, previous);
                break;
            }
            case INT8: {
                switch (newSchema.type()) {
                    case INT8: 
                    case INT16: 
                    case INT32: 
                    case INT64: 
                    case FLOAT32: 
                    case FLOAT64: {
                        return;
                    }
                    case BYTES: {
                        if (!includeDecimal || !SchemaValidators.isDecimal(newSchema)) break;
                        return;
                    }
                }
                SchemaValidators.failChangingType(newSchema, previous);
                break;
            }
            case INT16: {
                switch (newSchema.type()) {
                    case INT16: 
                    case INT32: 
                    case INT64: 
                    case FLOAT32: 
                    case FLOAT64: {
                        return;
                    }
                    case BYTES: {
                        if (!includeDecimal || !SchemaValidators.isDecimal(newSchema)) break;
                        return;
                    }
                }
                SchemaValidators.failChangingType(newSchema, previous);
                break;
            }
            case INT32: {
                switch (newSchema.type()) {
                    case INT32: 
                    case INT64: 
                    case FLOAT32: 
                    case FLOAT64: {
                        return;
                    }
                    case BYTES: {
                        if (!includeDecimal || !SchemaValidators.isDecimal(newSchema)) break;
                        return;
                    }
                }
                SchemaValidators.failChangingType(newSchema, previous);
                break;
            }
            case INT64: {
                switch (newSchema.type()) {
                    case INT64: 
                    case FLOAT32: 
                    case FLOAT64: {
                        return;
                    }
                    case BYTES: {
                        if (!includeDecimal || !SchemaValidators.isDecimal(newSchema)) break;
                        return;
                    }
                }
                SchemaValidators.failChangingType(newSchema, previous);
                break;
            }
            case FLOAT32: {
                switch (newSchema.type()) {
                    case FLOAT32: 
                    case FLOAT64: {
                        return;
                    }
                    case BYTES: {
                        if (!includeDecimal || !SchemaValidators.isDecimal(newSchema)) break;
                        return;
                    }
                }
                break;
            }
            case FLOAT64: {
                switch (newSchema.type()) {
                    case FLOAT64: {
                        return;
                    }
                    case BYTES: {
                        if (!includeDecimal || !SchemaValidators.isDecimal(newSchema)) break;
                        return;
                    }
                }
                break;
            }
            case STRING: {
                switch (newSchema.type()) {
                    case STRING: {
                        return;
                    }
                }
                SchemaValidators.failChangingType(newSchema, previous);
                break;
            }
            case ARRAY: {
                if (newSchema.type() != Schema.Type.ARRAY) {
                    SchemaValidators.failChangingType(newSchema, previous);
                }
                SchemaValidators.checkNumericExpansion(newSchema.valueSchema(), previous.valueSchema(), includeDecimal);
                return;
            }
            case MAP: {
                if (newSchema.type() != Schema.Type.MAP) {
                    SchemaValidators.failChangingType(newSchema, previous);
                }
                SchemaValidators.checkNumericExpansion(newSchema.keySchema(), previous.keySchema(), includeDecimal);
                SchemaValidators.checkNumericExpansion(newSchema.valueSchema(), previous.valueSchema(), includeDecimal);
                return;
            }
            case STRUCT: {
                if (newSchema.type() != Schema.Type.STRUCT) {
                    SchemaValidators.failChangingType(newSchema, previous);
                }
                newSchema.fields().forEach(field -> {
                    Field previousField = previous.field(field.name());
                    if (previousField != null) {
                        SchemaValidators.checkNumericExpansion(field.schema(), previousField.schema(), includeDecimal);
                    }
                });
                return;
            }
        }
        if (newSchema.type() != previous.type()) {
            SchemaValidators.failChangingType(newSchema, previous);
        }
        if (Objects.equals(newSchema.name(), previous.name())) {
            SchemaValidators.failChangingType(newSchema, previous);
        }
    }

    private static boolean isDecimal(Schema schema) {
        return schema.type() == Schema.Type.BYTES && "org.apache.kafka.connect.data.Decimal".equals(schema.name());
    }
}

