/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import io.confluent.connect.utils.schema.InvalidSchemaChangeException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

@FunctionalInterface
public interface SchemaValidator {
    public void validate(Schema var1, Schema var2) throws InvalidSchemaChangeException;

    default public SchemaValidator and(SchemaValidator other) {
        if (other == this || other == null) {
            return this;
        }
        SchemaValidator first = this;
        return (newSchema, previous) -> {
            first.validate(newSchema, previous);
            other.validate(newSchema, previous);
        };
    }

    default public SchemaValidator or(SchemaValidator other) {
        if (other == this || other == null) {
            return this;
        }
        SchemaValidator first = this;
        return (newSchema, previous) -> {
            try {
                first.validate(newSchema, previous);
            }
            catch (ConnectException e1) {
                try {
                    other.validate(newSchema, previous);
                }
                catch (ConnectException e2) {
                    throw e1;
                }
            }
        };
    }
}

