/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import io.confluent.connect.utils.schema.FieldPath;
import java.util.function.Function;
import org.apache.kafka.connect.errors.DataException;

public class SchemaNameFormatters {
    public static Function<FieldPath, String> defaultFormatter() {
        return SchemaNameFormatters.avroCompatibleFormatter();
    }

    public static Function<FieldPath, String> jsonPathFormatter() {
        return fieldPath -> fieldPath == null ? null : fieldPath.asString();
    }

    public static Function<FieldPath, String> avroCompatibleFormatter() {
        return new AvroCompatibleFormatter();
    }

    private static class AvroCompatibleFormatter
    implements Function<FieldPath, String> {
        private AvroCompatibleFormatter() {
        }

        @Override
        public String apply(FieldPath fieldPath) {
            if (fieldPath == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            fieldPath.onPath(node -> {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                if (node.isArrayIndex()) {
                    sb.append(node.index());
                } else {
                    for (char c : node.name().toCharArray()) {
                        if (Character.isLetterOrDigit(c) || c == '_') {
                            sb.append(c);
                            continue;
                        }
                        sb.append('_');
                    }
                }
            });
            String name = sb.toString();
            if (name.length() == 0) {
                throw new DataException("Empty name for struct schema is invalid.");
            }
            char c = name.charAt(0);
            if (Character.isLetter(c) || c == '_') {
                return name;
            }
            return "_" + name;
        }
    }
}

