/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import io.confluent.connect.utils.schema.FieldPath;
import io.confluent.connect.utils.schema.PathMatcher;
import io.confluent.connect.utils.schema.SchemaDefault;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;

public class SchemaDefaults {
    private static final SchemaDefault ALWAYS_NONE = SchemaDefaults::alwaysNone;
    private static final SchemaDefault ALWAYS_NULL = SchemaDefaults::alwaysNull;
    private static final SchemaDefault EMPTY_STRING = SchemaDefaults::emptyString;
    private static final SchemaDefault NUMERIC_ZEROS = SchemaDefaults::numericZeros;
    private static final Map<Schema.Type, Object> NUMERIC_BY_TYPE;

    public static SchemaDefault none() {
        return ALWAYS_NONE;
    }

    static Object alwaysNone(FieldPath path, Schema schema) {
        return SchemaDefault.NONE;
    }

    public static SchemaDefault alwaysNull() {
        return ALWAYS_NULL;
    }

    static Object alwaysNull(FieldPath path, Schema schema) {
        return null;
    }

    public static SchemaDefault numericZeros() {
        return NUMERIC_ZEROS;
    }

    static Object numericZeros(FieldPath path, Schema schema) {
        return NUMERIC_BY_TYPE.get(schema.type());
    }

    public static SchemaDefault emptyString() {
        return EMPTY_STRING;
    }

    static Object emptyString(FieldPath path, Schema schema) {
        return schema.type() == Schema.Type.STRING ? "" : null;
    }

    public static SchemaDefault literalDefault(Schema.Type expectedType, Object value) {
        Objects.requireNonNull(expectedType);
        return (path, schema) -> schema.type() == expectedType ? value : null;
    }

    public static SchemaDefault literalDefault(FieldPath expectedPath, Object value) {
        Objects.requireNonNull(expectedPath);
        return SchemaDefaults.literalDefault(PathMatcher.match(expectedPath), value);
    }

    public static SchemaDefault literalDefault(PathMatcher pathMatcher, Object value) {
        Objects.requireNonNull(pathMatcher);
        return (path, schema) -> {
            FieldPath actualPath = path != null ? path : FieldPath.EMPTY;
            return pathMatcher.matches(actualPath) ? value : null;
        };
    }

    static {
        HashMap<Schema.Type, Number> byType = new HashMap<Schema.Type, Number>();
        byType.put(Schema.Type.INT8, (byte)0);
        byType.put(Schema.Type.INT16, (short)0);
        byType.put(Schema.Type.INT32, 0);
        byType.put(Schema.Type.INT64, 0L);
        byType.put(Schema.Type.FLOAT32, Float.valueOf(0.0f));
        byType.put(Schema.Type.FLOAT64, 0.0);
        NUMERIC_BY_TYPE = Collections.unmodifiableMap(byType);
    }
}

