/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import io.confluent.connect.utils.collect.ImmutableSet;
import io.confluent.connect.utils.schema.FieldPath;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface PathMatcher {
    public boolean matches(FieldPath var1);

    default public PathMatcher or(PathMatcher matcher) {
        return matcher == null ? this : path -> this.matches(path) || matcher.matches(path);
    }

    default public PathMatcher and(PathMatcher matcher) {
        return matcher == null ? this : path -> this.matches(path) && matcher.matches(path);
    }

    public static PathMatcher matchAll() {
        return p -> true;
    }

    public static PathMatcher matchNonNullPaths() {
        return p -> p != null;
    }

    public static PathMatcher matchNone() {
        return p -> false;
    }

    public static PathMatcher matchAnyOf(FieldPath ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("At least one path must be specified");
        }
        Set allowedPaths = ImmutableSet.of(paths).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        return p -> allowedPaths.contains(p);
    }

    public static PathMatcher matchAnyOf(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("At least one path must be specified");
        }
        Set allowedPaths = ImmutableSet.of(paths).stream().filter(Objects::nonNull).map(FieldPath::parse).collect(Collectors.toSet());
        return p -> allowedPaths.contains(p);
    }

    public static PathMatcher match(FieldPath path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        return p -> path.equals(p);
    }

    public static PathMatcher matchDescendantOf(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        return PathMatcher.matchDescendantOf(FieldPath.parse(path));
    }

    public static PathMatcher matchDescendantOf(FieldPath path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        int depth = path.depth();
        return p -> p.depth() > depth && path.equals(p.ancestorAtDepth(depth));
    }

    public static PathMatcher matchPathOrDescendantOf(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        return PathMatcher.matchPathOrDescendantOf(FieldPath.parse(path));
    }

    public static PathMatcher matchPathOrDescendantOf(FieldPath path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        int depth = path.depth();
        return p -> p.depth() >= depth && p.equals(path) || path.equals(p.ancestorAtDepth(depth));
    }

    public static PathMatcher matchChildOf(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        return PathMatcher.matchChildOf(FieldPath.parse(path));
    }

    public static PathMatcher matchChildOf(FieldPath path) {
        if (path == null) {
            throw new IllegalArgumentException("The specified path to match may not be null");
        }
        int childDepth = path.depth() + 1;
        return p -> p.depth() == childDepth && path.equals(p.parent());
    }

    public static PathMatcher matchName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The specified name may not be null");
        }
        return p -> p.name().equals(name);
    }

    public static PathMatcher matchAnyNames(String ... names) {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("At least one child name must be specified");
        }
        Set allowedNames = ImmutableSet.of(names).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        return p -> allowedNames.contains(p.name());
    }

    public static PathMatcher matchChildWithName(String path, String ... childNames) {
        return PathMatcher.matchChildWithName(FieldPath.parse(path), childNames);
    }

    public static PathMatcher matchChildWithName(FieldPath path, String ... childNames) {
        return PathMatcher.matchChildOf(path).and(PathMatcher.matchAnyNames(childNames));
    }
}

