/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

public interface LogicalTypeMatcher {
    public boolean isTimestampLiteral(String var1);

    public boolean isTimeLiteral(String var1);

    public boolean isDateLiteral(String var1);

    default public LogicalTypeMatcher and(final LogicalTypeMatcher other) {
        if (other == this || other == null) {
            return this;
        }
        final LogicalTypeMatcher first = this;
        return new LogicalTypeMatcher(){

            @Override
            public boolean isTimestampLiteral(String value) {
                return first.isTimestampLiteral(value) && other.isTimestampLiteral(value);
            }

            @Override
            public boolean isTimeLiteral(String value) {
                return first.isTimeLiteral(value) && other.isTimeLiteral(value);
            }

            @Override
            public boolean isDateLiteral(String value) {
                return first.isDateLiteral(value) && other.isDateLiteral(value);
            }
        };
    }

    default public LogicalTypeMatcher or(final LogicalTypeMatcher other) {
        if (other == this || other == null) {
            return this;
        }
        final LogicalTypeMatcher first = this;
        return new LogicalTypeMatcher(){

            @Override
            public boolean isTimestampLiteral(String value) {
                return first.isTimestampLiteral(value) || other.isTimestampLiteral(value);
            }

            @Override
            public boolean isTimeLiteral(String value) {
                return first.isTimeLiteral(value) || other.isTimeLiteral(value);
            }

            @Override
            public boolean isDateLiteral(String value) {
                return first.isDateLiteral(value) || other.isDateLiteral(value);
            }
        };
    }
}

