/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;

public class InvalidSchemaChangeException
extends ConnectException {
    public final Schema previousSchema;
    public final Schema newSchema;

    private static Schema schema(Schema schema) {
        return schema instanceof SchemaBuilder ? ((SchemaBuilder)schema).build() : schema;
    }

    public InvalidSchemaChangeException(Schema previousSchema, Schema newSchema, String s) {
        super(s);
        this.previousSchema = InvalidSchemaChangeException.schema(previousSchema);
        this.newSchema = InvalidSchemaChangeException.schema(newSchema);
    }

    public InvalidSchemaChangeException(Schema previousSchema, Schema newSchema, String s, Throwable throwable) {
        super(s, throwable);
        this.previousSchema = InvalidSchemaChangeException.schema(previousSchema);
        this.newSchema = InvalidSchemaChangeException.schema(newSchema);
    }

    public InvalidSchemaChangeException(Schema previousSchema, Schema newSchema, Throwable throwable) {
        super(throwable);
        this.previousSchema = InvalidSchemaChangeException.schema(previousSchema);
        this.newSchema = InvalidSchemaChangeException.schema(newSchema);
    }
}

