/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.schema;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.collect.ImmutableIterator;
import io.confluent.connect.utils.schema.InvalidFieldPathException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;

public class FieldPath
implements Iterable<FieldPath> {
    public static final FieldPath EMPTY = new FieldPath("", null, null);
    protected static final char DELIMITER = '.';
    protected static final String DELIMITER_STR = ".";
    protected static final char OPEN_BRACKET = '[';
    protected static final char CLOSE_BRACKET = ']';
    protected static final String QUOTE_STR = "'";
    protected static final String OPEN_BRACKET_STR = "[";
    protected static final String CLOSE_BRACKET_STR = "]";
    private final FieldPath parent;
    private final String name;
    private final Integer index;
    private final int hc;
    private final int depth;

    public static FieldPath parse(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Unable to parse a null path");
        }
        if ((path = path.replaceFirst("^[$][.]?", "")).isEmpty()) {
            throw new InvalidFieldPathException("Unable to parse an empty path");
        }
        if (path.isEmpty()) {
            throw new InvalidFieldPathException("Unable to parse an empty path");
        }
        FieldPath pathParent = null;
        int startIndex = 0;
        while (startIndex < path.length()) {
            if (path.charAt(startIndex) == '[') {
                int fromIndex = startIndex + 1;
                int endQuote = FieldPath.findCloseBrace(path, fromIndex);
                if (FieldPath.isQuoted(path, fromIndex, endQuote)) {
                    String name = FieldPath.removeQuotesFrom(path, fromIndex, endQuote);
                    pathParent = new FieldPath(name, pathParent);
                } else {
                    String indexStr = FieldPath.nameFrom(path, fromIndex, endQuote);
                    try {
                        int index = Integer.parseInt(indexStr);
                        pathParent = new FieldPath(index, pathParent);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidFieldPathException(String.format("Expected integer but found \"%s\" at position %d: %s", indexStr, fromIndex, path));
                    }
                }
                startIndex = endQuote + 1;
            } else {
                int delimIndex = Strings.firstIndexOf(path, '.', '[', startIndex);
                String name = FieldPath.nameFrom(path, startIndex, delimIndex);
                pathParent = new FieldPath(name, pathParent);
                int n = startIndex = delimIndex < 0 ? path.length() : delimIndex;
            }
            if (path.length() <= startIndex) {
                return pathParent;
            }
            if (path.charAt(startIndex) != '.') continue;
            ++startIndex;
        }
        return pathParent;
    }

    protected static boolean isQuoted(String path, int startIndex, int endIndex) {
        String name = endIndex < 0 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
        return name.startsWith(QUOTE_STR) && name.endsWith(QUOTE_STR) && name.length() >= 2;
    }

    protected static String removeQuotesFrom(String path, int startIndex, int endIndex) {
        String name;
        String string = name = endIndex < 0 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
        if (!name.startsWith(QUOTE_STR) || !name.endsWith(QUOTE_STR) || name.length() < 2) {
            throw new InvalidFieldPathException(String.format("Path segments expected to be quoted at position %d: %s", startIndex, path));
        }
        if ((name = name.substring(1, name.length() - 1)).isEmpty()) {
            throw new InvalidFieldPathException(String.format("Path segments may not be empty at position %d: %s", startIndex, path));
        }
        return name;
    }

    protected static String nameFrom(String path, int startIndex, int endIndex) {
        String name;
        String string = name = endIndex < 0 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
        if (name.isEmpty()) {
            throw new InvalidFieldPathException(String.format("Path segments may not be empty at position %d: %s", startIndex, path));
        }
        if (name.startsWith(QUOTE_STR) || name.endsWith(QUOTE_STR)) {
            throw new InvalidFieldPathException(String.format("Path segments may not be unquoted at position %d: %s", startIndex, path));
        }
        return name;
    }

    protected static int findCloseBrace(String path, int fromIndex) {
        int endQuote = path.indexOf(93, fromIndex);
        if (endQuote < 0) {
            throw new InvalidFieldPathException(String.format("Unable to find close backet matching open bracket at position %d: %s", fromIndex, path));
        }
        return endQuote;
    }

    public FieldPath(String name) {
        this(name, null);
    }

    public FieldPath(String name, FieldPath parent) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The name may not be null or blank");
        }
        this.name = name;
        this.parent = parent;
        this.index = null;
        this.hc = Objects.hash(parent, name, this.index);
        this.depth = parent == null ? 1 : parent.depth + 1;
    }

    public FieldPath(int index, FieldPath parent) {
        this(Integer.toString(index), index, parent);
    }

    protected FieldPath(String name, Integer index, FieldPath parent) {
        this.name = name;
        this.parent = parent;
        this.index = index;
        this.hc = Objects.hash(parent, name, index);
        this.depth = parent == null ? 1 : parent.depth + 1;
    }

    public String name() {
        return this.name;
    }

    public Integer index() {
        return this.index;
    }

    public boolean isArrayIndex() {
        return this.index != null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int depth() {
        return this.depth;
    }

    public FieldPath root() {
        return this.isRoot() ? this : this.parent.root();
    }

    public FieldPath parent() {
        return this.isRoot() ? null : this.parent;
    }

    public FieldPath ancestorAtDepth(int depth) {
        FieldPath result;
        for (result = this; result != null && result.depth != depth; result = result.parent()) {
        }
        return result;
    }

    public void onPath(Consumer<FieldPath> function) {
        if (this.parent != null) {
            this.parent.onPath(function);
        }
        function.accept(this);
    }

    public FieldPath child(String field) {
        return new FieldPath(field, this);
    }

    public Object resolve(Object value) {
        return new Resolver(this, value).resolve();
    }

    public FieldPath append(FieldPath path) {
        FieldPath parent = this;
        if (path != null) {
            for (FieldPath element : path) {
                parent = new FieldPath(element.name(), parent);
            }
        }
        return parent;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FieldPath) {
            FieldPath that = (FieldPath)obj;
            if (this.depth() != that.depth()) {
                return false;
            }
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent);
        }
        return false;
    }

    @Override
    public Iterator<FieldPath> iterator() {
        LinkedList nodePath = new LinkedList();
        this.onPath(node -> nodePath.add(node));
        return ImmutableIterator.of(nodePath);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.asString(DELIMITER_STR, FieldPath::name);
    }

    protected String asString(Function<FieldPath, String> getName) {
        return this.asString(DELIMITER_STR, getName);
    }

    protected String asString(String delimiter) {
        return this.asString(delimiter, FieldPath::name);
    }

    protected String asString(String delimiter, Function<FieldPath, String> getName) {
        StringBuilder sb = new StringBuilder();
        sb.append("$");
        this.onPath(node -> {
            sb.append(OPEN_BRACKET_STR);
            if (node.isArrayIndex()) {
                sb.append(node.index());
            } else {
                sb.append(QUOTE_STR).append(node.name()).append(QUOTE_STR);
            }
            sb.append(CLOSE_BRACKET_STR);
        });
        return sb.toString();
    }

    protected static class Resolver {
        private final FieldPath originalPath;
        private final Object originalValue;
        private Object value;

        public Resolver(FieldPath path, Object value) {
            this.originalPath = path;
            this.originalValue = value;
            this.value = value;
        }

        public Object resolve() {
            this.originalPath.onPath(this::resolveNext);
            return this.value;
        }

        protected void resolveNext(FieldPath nextSegment) {
            if (this.value == null) {
                return;
            }
            if (this.value instanceof Struct) {
                Struct struct = (Struct)this.value;
                String fieldName = nextSegment.name();
                Field field = struct.schema().field(fieldName);
                if (field != null) {
                    this.value = struct.get(field);
                    return;
                }
            }
            if (this.value instanceof Map) {
                Map map = (Map)this.value;
                this.value = map.get(nextSegment.name());
                return;
            }
            if (this.value instanceof List) {
                List list = (List)this.value;
                Integer index = nextSegment.index();
                if (index != null) {
                    this.value = index < list.size() ? list.get(nextSegment.index()) : null;
                    return;
                }
            }
            String msg = nextSegment.isRoot() ? String.format("Unable to resolve path %s for value", this.originalPath) : String.format("Unable to resolve path %s beyond %s for value", this.originalPath, nextSegment.parent());
            throw new InvalidFieldPathException(msg);
        }
    }
}

