/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.retry;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.errors.RetriableException;

@FunctionalInterface
public interface RetryCondition {
    public boolean isRetriable(Exception var1);

    default public RetryCondition or(RetryCondition other) {
        Objects.requireNonNull(other);
        return e -> this.isRetriable(e) || other.isRetriable(e);
    }

    default public RetryCondition and(RetryCondition other) {
        Objects.requireNonNull(other);
        return e -> this.isRetriable(e) && other.isRetriable(e);
    }

    default public RetryCondition orInstanceOf(Class<? extends Exception> ... errorClasses) {
        Objects.requireNonNull(errorClasses);
        if (errorClasses.length == 0) {
            throw new IllegalArgumentException("At least one exception class must be specified");
        }
        return this.or(RetryCondition.retryOn(errorClasses));
    }

    default public RetryCondition orConnectRetriable() {
        return this.or(RetryCondition.retryOnConnectRetriable());
    }

    default public RetryCondition orKafkaRetriable() {
        return this.or(RetryCondition.retryOnKafkaRetriable());
    }

    default public RetryCondition orSqlException() {
        return this.or(RetryCondition.retryOnAnySqlException());
    }

    default public RetryCondition orSqlExceptionMatching(Function<SQLException, Boolean> condition) {
        Objects.requireNonNull(condition);
        return this.or(RetryCondition.retryOnSqlExceptionMatching(condition));
    }

    default public RetryCondition orSqlExceptionCodeIs(int ... errorCodes) {
        if (errorCodes.length == 0) {
            throw new IllegalArgumentException("At least one error code must be specified");
        }
        return this.or(RetryCondition.retryOnSqlExceptionCode(errorCodes));
    }

    public static RetryCondition always() {
        return e -> true;
    }

    public static RetryCondition never() {
        return e -> false;
    }

    public static RetryCondition retryOn(Class<? extends Exception> errorClass) {
        Objects.requireNonNull(errorClass);
        return e -> errorClass.isInstance(e);
    }

    public static RetryCondition retryOn(Class<? extends Exception> ... errorClasses) {
        if (errorClasses.length == 0) {
            throw new IllegalArgumentException("At least one exception class must be specified");
        }
        return e -> Arrays.stream(errorClasses).filter(clazz -> clazz.isInstance(e)).findFirst().isPresent();
    }

    public static <T extends Exception> RetryCondition retryOn(Function<T, Boolean> criteria) {
        Objects.requireNonNull(criteria);
        return e -> {
            try {
                return (Boolean)criteria.apply(e);
            }
            catch (ClassCastException error) {
                return false;
            }
        };
    }

    public static RetryCondition retryOnConnectRetriable() {
        return RetryCondition.retryOn(org.apache.kafka.connect.errors.RetriableException.class);
    }

    public static RetryCondition retryOnKafkaRetriable() {
        return RetryCondition.retryOn(RetriableException.class);
    }

    public static RetryCondition retryOnAnySqlException() {
        return RetryCondition.retryOn(SQLException.class);
    }

    public static RetryCondition retryOnSqlExceptionMatching(Function<SQLException, Boolean> criteria) {
        Objects.requireNonNull(criteria);
        return RetryCondition.retryOnAnySqlException().and(e -> {
            SQLException sqlException = (SQLException)e;
            do {
                if (!((Boolean)criteria.apply(sqlException)).booleanValue()) continue;
                return true;
            } while ((sqlException = sqlException.getNextException()) != null);
            return false;
        });
    }

    public static RetryCondition retryOnSqlExceptionCode(int ... errorCodes) {
        if (errorCodes.length == 0) {
            throw new IllegalArgumentException("At least one error code must be specified");
        }
        return RetryCondition.retryOnSqlExceptionMatching(sqlException -> {
            int errorCode = sqlException.getErrorCode();
            for (int expectedErrorCode : errorCodes) {
                if (errorCode != expectedErrorCode) continue;
                return true;
            }
            return false;
        });
    }
}

