/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.retry;

import io.confluent.connect.utils.retry.BackoffPolicy;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

class ExponentialJitterBackoffPolicy
implements BackoffPolicy {
    protected static final long MAX_RETRY_TIME_MS = TimeUnit.HOURS.toMillis(24L);
    private final long initialRetryBackoffMillis;
    private final long maxRetryTimeMillis;

    public ExponentialJitterBackoffPolicy(long initialRetryBackoff, TimeUnit unit) {
        this(initialRetryBackoff, unit.convert(MAX_RETRY_TIME_MS, TimeUnit.MILLISECONDS), unit);
    }

    public ExponentialJitterBackoffPolicy(long initialRetryBackoff, long maxRetryTime, TimeUnit unit) {
        if (initialRetryBackoff < 0L) {
            throw new IllegalArgumentException("The initial retry backoff time may not be negative");
        }
        if (maxRetryTime < initialRetryBackoff) {
            throw new IllegalArgumentException("The max retry time must be larger than initial backoff");
        }
        this.initialRetryBackoffMillis = unit.toMillis(initialRetryBackoff);
        this.maxRetryTimeMillis = unit.toMillis(maxRetryTime);
    }

    @Override
    public long computeBackoffMillis(int attemptNumber) {
        if (attemptNumber < 0) {
            return this.initialRetryBackoffMillis;
        }
        long maxRetryTime = ExponentialJitterBackoffPolicy.computeRetryWaitTimeInMillis(attemptNumber, this.initialRetryBackoffMillis, this.maxRetryTimeMillis);
        if (maxRetryTime == 0L) {
            return 0L;
        }
        return ThreadLocalRandom.current().nextLong(0L, maxRetryTime);
    }

    @Override
    public String type() {
        return String.format("exponential (%s-%s ms)", this.initialRetryBackoffMillis, this.maxRetryTimeMillis);
    }

    public static long computeRetryWaitTimeInMillis(int retryAttempts, long initialRetryBackoffMs, long maxRetryMs) {
        long result;
        if (initialRetryBackoffMs < 0L) {
            return 0L;
        }
        if (retryAttempts <= 0) {
            return initialRetryBackoffMs;
        }
        if (maxRetryMs < initialRetryBackoffMs) {
            throw new IllegalArgumentException("The maximum retry backoff time must be larger than the initial time");
        }
        if (retryAttempts >= 64) {
            return maxRetryMs;
        }
        if (initialRetryBackoffMs == 0L) {
            initialRetryBackoffMs = 1L;
        }
        return (result = initialRetryBackoffMs << retryAttempts) <= 0L ? maxRetryMs : Math.min(maxRetryMs, result);
    }
}

