/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.retry;

import io.confluent.connect.utils.retry.BackoffPolicy;
import java.util.concurrent.TimeUnit;

class ConstantBackoffPolicy
implements BackoffPolicy {
    private final long backoffInMillis;

    public ConstantBackoffPolicy(long backoffTime, TimeUnit unit) {
        if (backoffTime <= 0L) {
            throw new IllegalArgumentException("The initial backoff time must be positive");
        }
        this.backoffInMillis = unit.toMillis(backoffTime);
    }

    @Override
    public long computeBackoffMillis(int attemptNumber) {
        return this.backoffInMillis;
    }

    @Override
    public String type() {
        return "constant (" + this.backoffInMillis + " ms)";
    }
}

