/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.retry;

import io.confluent.connect.utils.retry.BackoffPolicy;
import io.confluent.connect.utils.retry.ConstantBackoffPolicy;
import io.confluent.connect.utils.retry.ExponentialJitterBackoffPolicy;
import io.confluent.connect.utils.retry.NoBackoffPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class BackoffPolicies {
    private static final BackoffPolicy NO_BACKOFF = new NoBackoffPolicy();

    public static BackoffPolicy noBackoff() {
        return NO_BACKOFF;
    }

    public static BackoffPolicy constantBackoff(Duration backoffDuration) {
        Objects.requireNonNull(backoffDuration);
        return new ConstantBackoffPolicy(backoffDuration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static BackoffPolicy exponentialJitter(Duration initialBackoff) {
        Objects.requireNonNull(initialBackoff);
        return new ExponentialJitterBackoffPolicy(initialBackoff.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static BackoffPolicy exponentialJitter(Duration initialBackoff, Duration maxRetryTime) {
        Objects.requireNonNull(initialBackoff);
        Objects.requireNonNull(maxRetryTime);
        return new ExponentialJitterBackoffPolicy(initialBackoff.toMillis(), maxRetryTime.toMillis(), TimeUnit.MILLISECONDS);
    }
}

