/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.recommenders;

import io.confluent.connect.utils.recommenders.ValidValuesCallback;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;

class VisibleIfRecommender
implements ConfigDef.Recommender {
    final String configKey;
    final Predicate<Object> enabledPredicate;
    final ValidValuesCallback validValuesCallback;

    VisibleIfRecommender(String configKey, Object value, ValidValuesCallback validValuesCallback) {
        this(configKey, (? v) -> value.equals(v), validValuesCallback);
    }

    VisibleIfRecommender(String configKey, Predicate<?> enabledPredicate, ValidValuesCallback validValuesCallback) {
        Objects.requireNonNull(configKey, "configKey cannot be null.");
        Objects.requireNonNull(enabledPredicate, "predicate cannot be null.");
        Objects.requireNonNull(validValuesCallback, "validValuesCallback cannot be null.");
        this.configKey = configKey;
        this.enabledPredicate = enabledPredicate;
        this.validValuesCallback = validValuesCallback;
    }

    public List<Object> validValues(String s, Map<String, Object> map) {
        return this.validValuesCallback.validValues(s, map);
    }

    public boolean visible(String key, Map<String, Object> settings) {
        Object v = settings.get(this.configKey);
        return this.enabledPredicate.test(v);
    }
}

