/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.recommenders;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.collect.ImmutableList;
import io.confluent.connect.utils.recommenders.CharsetRecommender;
import io.confluent.connect.utils.recommenders.EnumRecommender;
import io.confluent.connect.utils.recommenders.ValidValuesCallback;
import io.confluent.connect.utils.recommenders.VisibleCallback;
import io.confluent.connect.utils.recommenders.VisibleIfRecommender;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.config.ConfigDef;

public class Recommenders {
    private Recommenders() {
    }

    public static ConfigDef.Recommender visibleIf(String configKey, Predicate<Object> enabledPredicate) {
        return new VisibleIfRecommender(configKey, enabledPredicate, ValidValuesCallback.EMPTY);
    }

    public static ConfigDef.Recommender visibleIf(String configKey, Set<Object> allowedValues) {
        return new VisibleIfRecommender(configKey, allowedValues::contains, ValidValuesCallback.EMPTY);
    }

    public static ConfigDef.Recommender visibleIf(String configKey, Object value) {
        return Recommenders.visibleIf(configKey, value, ValidValuesCallback.EMPTY);
    }

    public static ConfigDef.Recommender visibleIf(String configKey, Object value, ValidValuesCallback validValuesCallback) {
        return new VisibleIfRecommender(configKey, value, validValuesCallback);
    }

    public static ConfigDef.Recommender visibleIf(String configKey, Object value, ConfigDef.Recommender validValuesRecommender) {
        ValidValuesCallback validValuesCallback = validValuesRecommender != null ? (arg_0, arg_1) -> ((ConfigDef.Recommender)validValuesRecommender).validValues(arg_0, arg_1) : ValidValuesCallback.EMPTY;
        return Recommenders.visibleIf(configKey, value, validValuesCallback);
    }

    public static ConfigDef.Recommender visibleIf(String configKey, Predicate<Object> enabledPredicate, ConfigDef.Recommender validValuesRecommender) {
        ValidValuesCallback validValuesCallback = validValuesRecommender != null ? (arg_0, arg_1) -> ((ConfigDef.Recommender)validValuesRecommender).validValues(arg_0, arg_1) : ValidValuesCallback.EMPTY;
        return new VisibleIfRecommender(configKey, enabledPredicate, validValuesCallback);
    }

    public static <T extends Enum> ConfigDef.Recommender enumValues(Class<T> enumClass, T ... excludes) {
        return Recommenders.enumValues(enumClass, (VisibleCallback)VisibleCallback.ALWAYS_VISIBLE, excludes);
    }

    public static <T extends Enum> ConfigDef.Recommender enumValues(Class<T> enumClass, VisibleCallback visible, T ... excludes) {
        return Recommenders.enumValues(enumClass, (VisibleCallback)visible, Strings::toLowerCase, excludes);
    }

    public static <T extends Enum> ConfigDef.Recommender enumValues(Class<T> enumClass, VisibleCallback visible, Function<String, String> conversion, T ... excludes) {
        return new EnumRecommender(enumClass, conversion != null ? conversion : Strings::toLowerCase, visible != null ? visible : VisibleCallback.ALWAYS_VISIBLE, excludes);
    }

    public static <T, V> ConfigDef.Recommender anyOf(Iterable<T> allowedValues, Function<T, V> mapping) {
        List values = StreamSupport.stream(allowedValues.spliterator(), false).map(mapping).collect(Collectors.toList());
        return Recommenders.anyOf(values);
    }

    public static ConfigDef.Recommender anyOf(Iterable<?> allowedValues) {
        final List<?> values = ImmutableList.copyOf(allowedValues);
        return new ConfigDef.Recommender(){

            public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
                return values;
            }

            public boolean visible(String name, Map<String, Object> parsedConfig) {
                return true;
            }
        };
    }

    public static ConfigDef.Recommender anyOf(Object ... allowedValues) {
        return Recommenders.anyOf(ImmutableList.copyOf(allowedValues));
    }

    public static ConfigDef.Recommender charset() {
        return Recommenders.charset(VisibleCallback.ALWAYS_VISIBLE, Charset.availableCharsets().keySet());
    }

    public static ConfigDef.Recommender charset(VisibleCallback visible) {
        return Recommenders.charset(visible, Charset.availableCharsets().keySet());
    }

    public static ConfigDef.Recommender charset(VisibleCallback visible, String ... charsets) {
        return Recommenders.charset(visible, ImmutableList.copyOf(charsets));
    }

    public static ConfigDef.Recommender charset(VisibleCallback visible, Iterable<String> charsets) {
        return new CharsetRecommender(charsets, visible);
    }
}

