/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.recommenders;

import io.confluent.connect.utils.collect.ImmutableList;
import io.confluent.connect.utils.collect.ImmutableSet;
import io.confluent.connect.utils.recommenders.VisibleCallback;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

class EnumRecommender<T extends Enum>
implements ConfigDef.Validator,
ConfigDef.Recommender {
    private final Set<String> validValues;
    private final Class<T> enumClass;
    private final VisibleCallback visible;

    public EnumRecommender(Class<T> enumClass, Function<String, String> conversion, VisibleCallback visible, T ... excludedValues) {
        String key;
        this.enumClass = enumClass;
        this.visible = visible;
        LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
        for (Enum o : (Enum[])enumClass.getEnumConstants()) {
            key = conversion.apply(o.toString());
            validEnums.add(key);
        }
        for (Enum excluded : excludedValues) {
            key = conversion.apply(excluded.toString());
            validEnums.remove(key);
        }
        this.validValues = ImmutableSet.copyOf(validEnums);
    }

    public void ensureValid(String key, Object value) {
        if (value != null && !this.validValues.contains(value.toString())) {
            throw new ConfigException(key, value, "Invalid enumerator");
        }
    }

    public String toString() {
        return this.validValues.toString();
    }

    public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
        return ImmutableList.copyOf(this.validValues);
    }

    public boolean visible(String name, Map<String, Object> connectorConfigs) {
        return this.visible.visible(name, connectorConfigs);
    }
}

