/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.collect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public interface ImmutableSet<T> {
    public static <T> Set<T> copyOf(Iterable<? extends T> values) {
        return values instanceof Collection ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.copyOf(values.iterator());
    }

    public static <T> Set<T> copyOf(Iterator<? extends T> values) {
        HashSet<T> copy = new HashSet<T>();
        while (values.hasNext()) {
            copy.add(values.next());
        }
        return Collections.unmodifiableSet(copy);
    }

    public static <T> Set<T> copyOf(Collection<? extends T> values) {
        return Collections.unmodifiableSet(new HashSet<T>(values));
    }

    public static <T> Set<T> copyOf(T ... values) {
        return ImmutableSet.of(values);
    }

    public static <T> Set<T> of(T ... values) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(values)));
    }
}

