/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.collect;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;

public interface ImmutableMap<K, V> {
    public static <K, V> Map<K, V> of() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> of(K k1, V v1) {
        return Collections.singletonMap(k1, v1);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> original) {
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        protected Map<K, V> entries = new LinkedHashMap();
        protected Function<Map<K, V>, Map<K, V>> copyConstructor = HashMap::new;

        public Builder<K, V> constructWith(Function<Map<K, V>, Map<K, V>> copyConstructor) {
            this.copyConstructor = Objects.requireNonNull(copyConstructor);
            return this;
        }

        public Builder<K, V> unordered() {
            return this.constructWith(HashMap::new);
        }

        public Builder<K, V> orderByKey() {
            return this.constructWith(TreeMap::new);
        }

        public Builder<K, V> orderByInsertion() {
            return this.constructWith(LinkedHashMap::new);
        }

        public Builder<K, V> put(K key, V value) {
            this.entries.put(key, value);
            return this;
        }

        public Builder<K, V> putAll(Map<K, V> map) {
            this.entries.putAll(map);
            return this;
        }

        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.copyConstructor.apply(this.entries));
        }
    }
}

