/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.collect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public interface ImmutableList<T> {
    public static <T> List<T> copyOf(Iterable<? extends T> values) {
        return values instanceof Collection ? ImmutableList.copyOf((Collection)values) : ImmutableList.copyOf(values.iterator());
    }

    public static <T> List<T> copyOf(Iterator<? extends T> values) {
        ArrayList<T> copy = new ArrayList<T>();
        while (values.hasNext()) {
            copy.add(values.next());
        }
        return Collections.unmodifiableList(copy);
    }

    public static <T> List<T> copyOf(Collection<? extends T> values) {
        return Collections.unmodifiableList(new ArrayList<T>(values));
    }

    public static <T> List<T> copyOf(T ... values) {
        return ImmutableList.of(values);
    }

    public static <T> List<T> of(T ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }
}

