/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.collect;

import java.util.Iterator;

public interface ImmutableIterator<T>
extends Iterator<T> {
    public static <T> Iterator<T> of(Iterable<T> original) {
        return original == null ? null : ImmutableIterator.of(original.iterator());
    }

    public static <T> Iterator<T> of(final Iterator<T> original) {
        if (original == null || original instanceof ImmutableIterator) {
            return original;
        }
        return new ImmutableIterator<T>(){

            @Override
            public boolean hasNext() {
                return original.hasNext();
            }

            @Override
            public T next() {
                return original.next();
            }
        };
    }
}

