/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils;

import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    private static final String PATH = "version.properties";
    static final String UNKNOWN_VERSION = "unknown";
    private static ConcurrentMap<Class<?>, String> versionsByClass = new ConcurrentHashMap();

    private Version() {
    }

    public static String forClass(Class<?> cls) {
        Objects.requireNonNull(cls, "The class reference may not be null");
        return versionsByClass.computeIfAbsent(cls, Version::readVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readVersion(Class<?> cls) {
        try {
            String version = cls.getPackage().getImplementationVersion();
            if (version != null && !version.trim().isEmpty()) {
                log.trace("Found version '{}' for package '{}'", (Object)version, (Object)cls.getPackage().getName());
                return version;
            }
            try (InputStream stream = cls.getResourceAsStream(PATH);){
                if (stream != null) {
                    Properties props = new Properties();
                    props.load(stream);
                    version = props.getProperty("version", UNKNOWN_VERSION).trim();
                    log.trace("Found version '{}' in '{}/{}' using classloader for {}", new Object[]{version, Version.modifiedPackageName(cls), PATH, cls.getName()});
                    String string2 = version;
                    return string2;
                }
                log.warn("Failed to find version for {} and using '{}' for version; expecting to find file '{}/{}' using classloader for {}", new Object[]{cls.getName(), UNKNOWN_VERSION, Version.modifiedPackageName(cls), PATH, cls.getName()});
                String string = UNKNOWN_VERSION;
                return string;
            }
        }
        catch (Exception e) {
            log.warn("Failed to find version for {} and using '{}' for version; error reading find file '{}/{}' using classloader for {}", new Object[]{cls.getName(), UNKNOWN_VERSION, Version.modifiedPackageName(cls), PATH, cls.getName(), e});
            return UNKNOWN_VERSION;
        }
    }

    protected static String modifiedPackageName(Class<?> clazz) {
        return clazz.getPackage().getName().replaceAll("[.]", "/");
    }
}

