/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils;

import java.util.Objects;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalCounter {
    private static final Logger log = LoggerFactory.getLogger(ConditionalCounter.class);
    private long counter = 0L;
    private long nextCounter;
    private final LongFunction<Long> incrementer;

    public static ConditionalCounter periodic(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("The interval must be positive");
        }
        return new ConditionalCounter(input -> {
            if (input == 0L) {
                return 1L;
            }
            if (input == 1L) {
                return interval;
            }
            return input + interval;
        });
    }

    public static ConditionalCounter logarithmicUntil(long maxInterval) {
        return ConditionalCounter.logarithmicUntil(maxInterval, 10L);
    }

    public static ConditionalCounter logarithmicUntil(long maxInterval, long factor) {
        if (maxInterval < 1L) {
            throw new IllegalArgumentException("The interval must be positive");
        }
        return new ConditionalCounter(input -> {
            if (input == 0L) {
                return 1L;
            }
            if (input < maxInterval) {
                return input * factor;
            }
            return input + maxInterval;
        });
    }

    public static ConditionalCounter constant(long increment) {
        if (increment < 1L) {
            throw new IllegalArgumentException("The increment must be positive");
        }
        return new ConditionalCounter(input -> increment);
    }

    protected ConditionalCounter(LongFunction<Long> incrementer) {
        this.incrementer = incrementer;
        this.nextCounter = incrementer.apply(0L);
    }

    public boolean incrementAndConditionally(Runnable function) {
        Objects.requireNonNull(function);
        ++this.counter;
        if (this.counter == this.nextCounter) {
            this.nextCounter = this.incrementer.apply(this.nextCounter);
            try {
                function.run();
            }
            catch (Throwable t) {
                log.error("Error while running conditional counter increment function", t);
            }
            return true;
        }
        return false;
    }

    public long current() {
        return this.counter;
    }

    public long next() {
        return this.nextCounter;
    }

    public void reset() {
        this.counter = 0L;
        this.nextCounter = this.incrementer.apply(this.counter);
    }

    public String toString() {
        return "Counter: current=" + this.current() + "; next=" + this.next();
    }
}

